package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TStatisticsTaxSalary;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TStatisticsTaxSalaryMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryAccount2022Service;
import com.yifu.cloud.plus.v1.yifu.salary.service.TStatisticsCurrentReportService;
import com.yifu.cloud.plus.v1.yifu.salary.service.TStatisticsTaxSalaryTwoService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 统计-工资薪金
 *
 * @author hgw
 * @date 2020-05-27 10:46:05
 */
@AllArgsConstructor
@Slf4j
@Service("tStatisticsTaxSalaryTwoService")
public class TStatisticsTaxSalaryTwoServiceImpl extends ServiceImpl<TStatisticsTaxSalaryMapper, TStatisticsTaxSalary> implements TStatisticsTaxSalaryTwoService {

	private final TSalaryAccount2022Service tSalaryAccount2020Service;

	private final TStatisticsCurrentReportService tStatisticsCurrentReportService;
     /**
      * @param tableName
      * @param declareMonth 申报月
      * @param lastMonth 上个月的结算数据
      * @Description: 刷新工资薪金
      * @Author: hgw
      * @Date: 2022/2/23 15:12
      * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
      **/
     @Override
     public R<String> doStatisticsTaxSalary(String tableName, String declareMonth, String lastMonth) {
          int deletes = baseMapper.deleteByYearMonth(declareMonth);
          if (deletes != -1) {
               String settleYear = lastMonth.substring(0, 4);
               baseMapper.insertStatisticsTaxSalaryByTableName(tableName, declareMonth, lastMonth, settleYear);
               return R.ok("刷新工资薪金成功！");
          }
          return R.failed("刷新工资薪金失败！");
     }

	@Override
	public void doRefreshStatisticsTaxAuto(String declareMonth) {
		// 2022-8-31 16:26 本期申报变更：徐梅、简洁确认修改最终：
		// 年度报账表，拉取上月数据（结算月为上月）
		// 工资薪金表，申报月为当月，结算月为上月，上月的年数据
		// 本期申报：  申报月为当月，减去上上月的回盘，拉取当月的申报对象
		String lastMonth = DateUtil.addMonthByString(declareMonth, -1);
		String lastTwoMonth = DateUtil.addMonthByString(declareMonth, -2);
		if (Common.isNotNull(lastMonth)) {
			String tableName = "t_salary_account_" + lastMonth.substring(0, 4);
			// 刷新对应结算月的 年度报账
			R<String> accountR = tSalaryAccount2020Service.doRefreshSalaryAccountByMonth(tableName, lastMonth);
			if (accountR != null && accountR.getCode() == CommonConstants.SUCCESS) {
				// 刷新对应结算月的 工资薪金
				R<String> taxR = this.doStatisticsTaxSalary(tableName, declareMonth, lastMonth);
				if (taxR.getCode() == CommonConstants.SUCCESS) {
					// 刷新对应结算月的 本期申报
					tStatisticsCurrentReportService.doRefreshStatisticsCurrentReport(declareMonth, lastMonth, lastTwoMonth);
				} else {
					log.info(taxR.getMsg());
				}
			} else {
				log.info(accountR == null ? "刷新对应结算月的 年度报账-失败！" : accountR.getMsg());
			}
		}
	}

}
