package com.yifu.cloud.plus.v1.yifu.social.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 获取对应单位或结算主体权限下的缴费库统计情况
 * @Author fxj
 * @Date 2020-08-31
 **/
@Data
public class PaymentBusinessPageDetail {
    /**
     * 账单人数 退费不计数
     **/
    @Schema(description  = "账单人数", name = "personalSum")
    private Integer personalCount;
    /**
     * 增员
     **/
    @Schema(description  = "增员", name = "personalSum")
    private Integer personalAdd;
    /**
     * 减员
     **/
    @Schema(description  = "减员", name = "personalSum")
    private Integer personalReduce;
    /**
     * 个人合计
     **/
    @Schema(description  = "个人合计", name = "personalSum")
    private BigDecimal personalSum;
    /**
     * 单位合计
     **/
    @Schema(description  = "单位合计", name = "unitSum")
    private BigDecimal unitSum;
    /**
     * 合计
     **/
    @Schema(description  = "合计", name = "sum")
    private BigDecimal sum;

}
