package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author fxj
 * @Date 2022/6/20
 * @Description
 * @Version 1.0
 */
@Data
public class EmpEducationUpdateExcelVo extends RowIndex {
	/**
	 * @Author fxj
	 * @Description 主键
	**/
	@ExcelAttribute(name = "唯一标识", isNotEmpty = true,errorInfo = "唯一标识不可为空")
	@NotNull(message = "唯一标识不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="唯一标识")
	private String id;

	/**
	 * 学校名称
	 */
	@ExcelAttribute(name = "学校", isNotEmpty = true,errorInfo = "学校不可为空",maxLength = 50)
	@NotNull(message = "学校不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学校")
	private String school;

	/**
	 * 院系名称
	 */
	@ExcelAttribute(name = "院系名称",maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="院系名称")
	private String collageSystem;


	/**
	 * 专业
	 */
	@ExcelAttribute(name = "专业", isNotEmpty = true,errorInfo = "专业不可为空",maxLength = 50)
	@NotNull(message = "专业不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="专业")
	private String major;

	/**
	 * 学历名称
	 */
	@ExcelAttribute(name = "学历", isNotEmpty = false,errorInfo = "学历不可为空", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION)
	@NotNull(message = "学历不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学历")
	private String educationName;

	/**
	 * 学历类型：全日制、自考、函授等
	 */
	@ExcelAttribute(name = "学历类型", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION_TYPE)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学历类型")
	private String type;

	/**
	 * 最高学历标识0是/1否
	 */
	@ExcelAttribute(name = "最高学历", isNotEmpty = true,errorInfo = "最高学历标识不可为空",readConverterExp = "0=是,1=否")
	@NotNull(message = "最高学历标识不可为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="最高学历")
	private String highIdentification;

	/**
	 * 学制类型：四年、三年、五年、二年
	 */
	@ExcelAttribute(name = "学制类型", isDataId = true, dataType = ExcelAttributeConstants.EDUCATION_SYSTEM)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="学制类型")
	private String educationSystem;

	/**
	 * 入学时间
	 */
	@ExcelAttribute(name = "入学时间", isNotEmpty = true,errorInfo = "入学时间不可为空",isDate = true)
	@NotNull(message = "入学时间不可为空")
	@DateTimeFormat("yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="入学时间")
	private Date entryDate;

	/**
	 * 结业日期
	 */
	@ExcelAttribute(name = "毕业时间", isNotEmpty = true,errorInfo = "毕业时间不可为空",isDate = true)
	@NotNull(message = "毕业时间不可为空")
	@DateTimeFormat("yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="毕业时间")
	private Date gradutionDate;

	/**
	 * 证书名称
	 */
	@ExcelAttribute(name = "证书名称",maxLength = 50)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="证书名称")
	private String certificationName;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注",maxLength = 200)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value ="备注")
	private String remark;
}
