/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.archives.utils;

import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 响应瓜子
 * @author lengleng
 */
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ReturnGz<T> implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final String GZ_OK_MSG = "成功";
	private static final String GZ_OK = "S00000";
	private static final String GZ_FAIL = "1";

	@Getter
	@Setter
	private String code;

	@Getter
	@Setter
	private String message;

	@Getter
	@Setter
	private String redirectUrl;

	@Getter
	@Setter
	private T data;

	public ReturnGz(T data) {
		super();
		this.data = data;
		this.code = "S00000";
	}

	public static <T> ReturnGz<T> ok() {
		return restResult(null, "S00000", GZ_OK_MSG);
	}

	public static <T> ReturnGz<T> ok(T data) {
		return restResult(data, GZ_OK, GZ_OK_MSG);
	}

	public static <T> ReturnGz<T> ok(T data, String msg) {
		return restResult(data, GZ_OK, msg);
	}

	public static <T> ReturnGz<T> failed() {
		return restResult(null, GZ_FAIL, null);
	}

	public static <T> ReturnGz<T> failed(String msg) {
		return restResult(null, GZ_FAIL, msg);
	}

	public static <T> ReturnGz<T> failed(T data) {
		return restResult(data, GZ_FAIL, null);
	}

	public static <T> ReturnGz<T> failed(T data, String msg) {
		return restResult(data, GZ_FAIL, msg);
	}


	private static <T> ReturnGz<T> restResult(T data, String code, String msg) {
		ReturnGz<T> apiResult = new ReturnGz<>();
		apiResult.setCode(code);
		apiResult.setData(data);
		apiResult.setMessage(msg);
		apiResult.setRedirectUrl(null);
		return apiResult;
	}

}
