package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * 流程审阅权限表（抄送/仅有查看权限）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_node_reader_promission")
@Schema(description = "流程审阅权限表（抄送/仅有查看权限）")
public class TNodeReaderPromission extends Model<TNodeReaderPromission> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;

     @Length(max = 255, message = "指定用户处理节点不能超过255个字符")
     @Schema(description = "指定用户处理节点")
     private String user;

     @Length(max = 255, message = "指定权限处理节点不能超过255个字符")
     @Schema(description = "指定权限处理节点")
     private String role;

     @Length(max = 255, message = "指定职位处理节点不能超过255个字符")
     @Schema(description = "指定职位处理节点")
     private String post;

     @Length(max = 255, message = "指定组织处理节点不能超过255个字符")
     @Schema(description = "指定组织处理节点")
     private String organization;

     @NotBlank(message = "与流程申请人关系（0上级/1同区域最高级/2同部门最高级）不能为空")
     @Length(max = 1, message = "与流程申请人关系（0上级/1同区域最高级/2同部门最高级）不能超过1个字符")
     @Schema(description = "与流程申请人关系（0上级/1同区域最高级/2同部门最高级）")
     private String realationCreateUser;

     @NotBlank(message = "标识（系统自动生成MD5串）不能为空")
     @Length(max = 255, message = "标识（系统自动生成MD5串）不能超过255个字符")
     @Schema(description = "标识（系统自动生成MD5串）")
     private String logoTitle;

     @NotBlank(message = "节点ID不能为空")
     @Length(max = 255, message = "节点ID不能超过255个字符")
     @Schema(description = "节点ID")
     private String nodeId;

     @NotBlank(message = "流程ID不能为空")
     @Length(max = 255, message = "流程ID不能超过255个字符")
     @Schema(description = "流程ID")
     private String processId;

     @NotBlank(message = "节点编码不能为空")
     @Length(max = 255, message = "节点编码不能超过255个字符")
     @Schema(description = "节点编码")
     private String nodeLogoTitle;

     @Length(max = 1, message = "类型：不能超过1个字符")
     @Schema(description = "类型：0指定职位;1与申请人关系;2指定权限;3指定用户;4指定组织;5指定角色(crm)")
     private Integer type;

     @Length(max = 20, message = "指定角色id不能超过20个字符")
     @Schema(description = "指定角色id")
     private String approvalRole;

     @Length(max = 20, message = "指定使用的代码自定义判断的标识字段不能超过20个字符")
     @Schema(description = "指定使用的代码自定义判断的标识字段")
     private String customizeField;

     @Schema(description = "是否代码自定义")
     private String isCustomize;
}
