package com.yifu.cloud.plus.v1.yifu.process.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.process.entity.TProcess;
import com.yifu.cloud.plus.v1.yifu.process.vo.ProcessVo;
import com.yifu.cloud.plus.v1.yifu.process.vo.TProcessViewVo;

/**
 * 主流程表
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
public interface TProcessService extends IService<TProcess> {

     /**
      * 主流程表简单分页查询
      *
      * @param tProcess 主流程表
      * @return
      */
     IPage<TProcessViewVo> getTProcessPage(Page<TProcessViewVo> page, TProcessViewVo tProcess,String type);

     /**
      * @param id
      * @Description: 返回ProcessVo
      * @Author: hgw
      * @Date: 2020/7/17 10:59
      * @return: ProcessVo
      **/
     ProcessVo getProcessVoById(String id);

	/**
	 * 根据流程类型查询ProcessVo
	 * @param processType 流程类型
	 *
	 * @return R<ProcessVo>
	 **/
     ProcessVo getProcessVoByType(String processType);

     /**
      * @param processVo
      * @Description: 保存流程
      * @Author: hgw
      * @Date: 2020/7/17 11:13
      * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R
      **/
     R saveProcessVo(ProcessVo processVo);

     /**
      * @param processId
      * @Description: 删除流程
      * @Author: hgw
      * @Date: 2020/7/17 17:20
      * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R
      **/
     R deleteById(String processId);

     R<String> add(TProcessViewVo tProcess);

     R<String> modify(TProcessViewVo vo);

    R<String> delete(String id);

     R<String> noUse(TProcess tProcess);

     /**
      * 根据角色ID获取关联流程
      *
      * @param tProcess 审批角色
      * @return IPage<TProcessViewVo>
      * @author chenyuxi
      * @date 2023-10-23 09:48:57
      * @since crm2.12.0
      */
     IPage<TProcessViewVo> getProcessPageByRoleId(Page<TProcessViewVo> page, TProcessViewVo tProcess);

    String checkProcessByRoleId(TProcessViewVo tProcess);


}
