package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.exception.CheckedException;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TInsuranceUnpurchaseApply;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TInsuranceUnpurchaseApplySearchVo;

import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 含风险项目不购买申请表
 *
 * @author huych
 * @date 2025-01-10 11:24:38
 */
public interface TInsuranceUnpurchaseApplyService extends IService<TInsuranceUnpurchaseApply> {
    /**
     * 含风险项目不购买申请表简单分页查询
     * @param tInsuranceUnpurchaseApply 含风险项目不购买申请表
     * @return
     */
    IPage<TInsuranceUnpurchaseApply> getTInsuranceUnpurchaseApplyPage(Page<TInsuranceUnpurchaseApply> page, TInsuranceUnpurchaseApplySearchVo tInsuranceUnpurchaseApply);

	R deleteById(String id);

	void listExport(HttpServletResponse response, TInsuranceUnpurchaseApplySearchVo searchVo);

	/**
	 * 审核分页
	 * @param page                    分页信息
	 * @param unpurchaseApplySearchVo 不购买申请查询信息
	 * @param userId                  登录用户id
	 * @param type                    0待审核、1已处理、2抄送我
	 * @return IPage
	 */
	IPage<TInsuranceUnpurchaseApply> getAuditPage(Page<TInsuranceUnpurchaseApply> page,
																		TInsuranceUnpurchaseApplySearchVo unpurchaseApplySearchVo,
													                    String userId, String type);
	/**
	 * 审核数量
	 * @param userId                  登录用户id
	 * @return IPage
	 */
	Map<String,Integer> getAuditCount(String userId);

	/**
	 * 提交审核
	 * @param id  实体id
	 * @return R<String>
	 **/
	R<String> commitOne(String id,YifuUser user) throws CheckedException;

	/**
	 * 审核
	 * @param insuranceUnpurchaseApply  审批信息
	 * @return R<String>
	 **/
	R<String> auditAndCommit(TInsuranceUnpurchaseApply insuranceUnpurchaseApply, String approvalResult, String approvalOpinion, YifuUser user)
			throws CheckedException;

	R addApply(TInsuranceUnpurchaseApply tInsuranceUnpurchaseApply);

	R<TInsuranceUnpurchaseApply> getDetailInfoById(String id);


}
