/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 费用划转vo
 * @author hgw
 * @date 2022-11-16 10:35:30
 */
@Data
public class ChangeDeptVo implements Serializable {

	// 申请人账号
	private String creator;

	// 划转前项目名称
	private String preProjectname;

	// 划转前项目编码
	private String preProjectno;

	// 划转前客户名称
	private String preCustomername;

	// 划转前客户编码
	private String preCustomerno;

	// 划转后项目名称
	private String nowProjectname;

	// 划转后项目编码
	private String nowProjectno;

	// 划转后客户名称
	private String nowCustomername;

	// 划转后客户编码
	private String nowCustomerno;

	// 划转类型：类型1;类型2;类型3
	private String transferType;

	// 社保明细
	private List<ChangeDeptDetailVo> shebao;

	// 公积金明细
	private List<ChangeDeptDetailVo> gongjijin;

	// 商险明细
	private List<ChangeDeptDetailVo> shangxian;

	// 管理费明细
	private List<ChangeDeptDetailVo> guanlifei;

	// 风险金明细
	private List<ChangeDeptDetailVo> fenxianjin;

	// 商险使用的项目信息
	private TSettleDomainSelectVo dept;

}
