/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitor;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TPreEmpMain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TMainExportAllVO;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TPreMainExportAllVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 预入职-主表
 *
 * @author hgw
 * @date 2024-06-17 11:31:08
 */
@Mapper
public interface TPreEmpMainMapper extends BaseMapper<TPreEmpMain> {
	/**
	 * 预入职-主表简单分页查询
	 *
	 * @param tPreEmpMain 预入职-主表
	 * @return
	 */
	IPage<TPreEmpMain> getTPreEmpMainPage(Page<TPreEmpMain> page, @Param("tPreEmpMain") TPreEmpMain tPreEmpMain);

	int getTPreEmpMainCount(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);

	List<TPreEmpMain> getTPreEmpMainList(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);

	int getTPreEmpMainAllCount(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);

	List<TPreMainExportAllVO> getTPreEmpMainAllList(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);
	List<TPreMainExportAllVO> getTPreEmpMainAllListByWork(@Param("preMainIdList") List<String> preMainIdList);
	List<TPreMainExportAllVO> getTPreEmpMainAllListByFamily(@Param("preMainIdList") List<String> preMainIdList);
	List<TPreMainExportAllVO> getTPreEmpMainAllListByProfessional(@Param("preMainIdList") List<String> preMainIdList);

	// 导出详情使用 hgw 2024-6-26 11:05:41
	int getTEmpMainAllCountOneWork(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);
	List<TPreMainExportAllVO> getTEmpMainAllListOneWork(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);

	int getTEmpMainAllCountTwoFamily(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);
	List<TPreMainExportAllVO> getTEmpMainAllListTwoFamily(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);

	int getTEmpMainAllCountThreeProfessional(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);
	List<TPreMainExportAllVO> getTEmpMainAllListThreeProfessional(@Param("tPreEmpMain") TPreEmpMain tPreEmpMain);

	TPreEmpMain getTPreEmpMainByCardAndDept(@Param("empIdCard") String empIdCard, @Param("deptId") String deptId);

	/* 导入预入职时，查询所有身份证的预入职使用的，查出来删除附属信息 */
	List<String> getTPreEmpMainListByCardAndDept(@Param("empIdCardList") List<String> empIdCardList, @Param("deptId") String deptId);

	TPreEmpMain getTPreEmpMainByCardAndDeptNo(@Param("empIdCard") String empIdCard, @Param("deptNo") String deptNo);

	// 以下都是清空临时表的数据
	void deleteBadByMainId(@Param("preMainId") String preMainId);
	void deleteContactByMainId(@Param("preMainId") String preMainId);
	void deleteDisabilityByMainId(@Param("preMainId") String preMainId);
	void deleteEducationByMainId(@Param("preMainId") String preMainId);
	void deleteFamilyByMainId(@Param("preMainId") String preMainId);
	void deleteEmployeeByMainId(@Param("preMainId") String preMainId);
	void deleteProjectByMainId(@Param("preMainId") String preMainId);
	
	// 以下都是清空临时表的数据
	void deleteBadByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteContactByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteDisabilityByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteEducationByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteFamilyByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteEmployeeByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteProjectByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteWorkRecordingByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteProfessionalByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteOtherFileByMainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deleteAttaByDomainIdList(@Param("preMainIdList") List<String> preMainIdList);
	void deletePreMainIdList(@Param("preMainIdList") List<String> preMainIdList);

}
