package com.yifu.cloud.plus.v1.business.vo.vacation;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @description: 假期配置规则VO
 * @author: wangweiguo
 * @date: 2021/8/13
 */
@Getter
@Setter
@ToString
public class VacationRuleConfigVO implements Serializable {
    /**
     * 主键
     */
	@Schema(description = "主键")
    private String id;

    /**
     * 假期类型 1年假
     */
	@Schema(description = "假期类型 1年假")
	private String type;

    /**
     * 是否自动发放假期时间 0否 1是
     */
	@Schema(description = "是否自动发放假期时间 0否 1是")
	private String vacationAutoInit;

    /**
     * 假期初始化时间
     */
	@Schema(description = "假期初始化时间")
	private LocalDate vacationInitDate;

    /**
     * 时间刻度 1按小时（和TIME_VALUE字段一起保证一天可以被不同单位数量的时间转换）
     */
	@Schema(description = "时间刻度 1按小时（和TIME_VALUE字段一起保证一天可以被不同单位数量的时间转换")
	private String timeScale;

    /**
     * 以时间刻度为单位的时间值（和TIME_SCALE字段一起保证一天可以被不同单位数量的时间转换）
     */
	@Schema(description = "以时间刻度为单位的时间值（和TIME_SCALE字段一起保证一天可以被不同单位数量的时间转换）")
	private BigDecimal timeValue;

}
