package com.yifu.cloud.plus.v1.business.service.salary;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yifu.cloud.plus.v1.business.entity.salary.TSalaryStatisticsPersonal;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsPersonalPageQuery;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsPersonalQuery;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryStatisticsPersonalVO;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryTotalVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * @description: 个人薪资变动统计表 service层
 * @author: wangweiguo
 * @date: 2021-09-07
*/
public interface TSalaryStatisticsPersonalService extends IService<TSalaryStatisticsPersonal> {

    /**
     * @description: 分页查询: 条件分页查询
     * @param query 查询条件
     * @return: R<IPage<TSalaryStatisticsPersonalVO>>
     * @author: wangweiguo
     * @date: 2021-09-07
    */
    R<IPage<TSalaryStatisticsPersonalVO>> getListByPage(TSalaryStatisticsPersonalPageQuery query);

    /**
     * 个人统计列表查询: 个人统计条件查询
     * @param query 个人统计查询条件
     * @return: R<List<TSalaryStatisticsPersonalVO>>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    R<List<TSalaryStatisticsPersonalVO>> getList(TSalaryStatisticsPersonalQuery query);

    /**
     * 个人合计: 条件查询个人合计
     * @param query 个人统计查询条件
     * @return: R<TSalaryTotalVO>
     * @author: wangweiguo
     * @date: 2021-09-07
     */
    R<TSalaryTotalVO> getSumPersonalByParams(TSalaryStatisticsPersonalQuery query);
}
