package com.yifu.cloud.plus.v1.csp.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 入离职登记表
 *
 * @author huych
 * @date 2025-02-25 14:48:11
 */
@Data
@ColumnWidth(17)
public class EmployeeRegistrationExportVo implements Serializable {

	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;

	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "员工手机号")
	@Schema(description = "员工手机号")
	@ExcelProperty("员工手机号")
	private String empPhone;

	@ExcelAttribute(name = "所属部门")
	@Schema(description = "所属部门")
	@ExcelProperty("所属部门")
	private String empDeptname;

	@ExcelAttribute(name = "就职岗位")
	@Schema(description = "就职岗位")
	@ExcelProperty("就职岗位")
	private String position;

	@ExcelAttribute(name = "登记类型")
	@Schema(description = "登记类型 1入职 2离职")
	@ExcelProperty("登记类型")
	private String feedbackType;

	@ExcelAttribute(name = "入/离职日期", isDate = true)
	@Schema(description = "入/离职日期")
	@ExcelProperty("入/离职日期")
	@DateTimeFormat("yyyy-MM-dd")
	private Date joinLeaveDate;

	@ExcelAttribute(name = "登记人")
	@Schema(description = "登记人")
	@ExcelProperty("登记人")
	private String registorUsername;

	@ExcelAttribute(name = "登记时间", isDate = true)
	@Schema(description = "登记时间")
	@ExcelProperty("登记时间")
	private Date createTime;

	@ExcelAttribute(name = "处理状态")
	@Schema(description = "处理状态,0已接收,1未处理,2已处理")
	@ExcelProperty("处理状态")
	private String processStatus;

}
