
package com.yifu.cloud.plus.v1.csp.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.csp.entity.EmployeeRegistration;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * 入离职登记表
 *
 * @author huych
 * @date 2025-02-25 14:48:11
 */
@Data
public class EmployeeRegistrationSearchVo extends EmployeeRegistration {

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	private String ids;

	/**
	 * 创建时间区间 [开始时间，结束时间]
	 */
	@Schema(description = "创建时间区间")
	private LocalDateTime[] createTimes;
	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	@Schema(description = "查询limit  开始")
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	@Schema(description = "查询limit  数据条数")
	private int limitEnd;

	//开始时间（查询专用）
	@Schema(description =  "创建开始时间")
	@TableField(exist = false)
	private LocalDateTime createTimeStart;

	//截止时间（查询专用）
	@Schema(description =  "创建截止时间")
	@TableField(exist = false)
	private LocalDateTime createTimeEnd;

	//开始时间（查询专用）
	@Schema(description =  "入离职开始时间")
	@TableField(exist = false)
	private LocalDateTime joinTimeStart;

	//截止时间（查询专用）
	@Schema(description =  "入离职截止时间")
	@TableField(exist = false)
	private LocalDateTime joinTimeEnd;

	@Schema(description =  "就职岗位数组")
	@TableField(exist = false)
	private List<String> postList;

	@Schema(description =  "处理状态数组")
	@TableField(exist = false)
	private List<String> statusList;

	@Schema(description =  "登记类型数组")
	@TableField(exist = false)
	private List<String> typeList;

	@Schema(description =  "部门权限数组")
	@TableField(exist = false)
	private Set<String> departIdSet;

}
