package com.yifu.cloud.plus.v1.ekp.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author hgw
 * @Date 2024-11-18 10:23:18
 * @Description EKP银企付款下载文件Vo
 * @Version 1.0
 */
@Data
public class EkpBankExcelVo implements Serializable {

	// 日期	明细标志	顺序号	报销号	单据张数	付款账号开户行	付款账号/卡号	付款账号名称/卡名称	收款账号开户行
	// 收款地区	收款银行人行行号	汇款方式	收款账号	收款账号名称	金额	汇款用途	备注信息	收款账户短信通知手机号码
	@ExcelProperty("日期")
	private String nowDate;
	@ExcelProperty("明细标志")
	private String detailTag;
	@ExcelProperty("顺序号")
	private String fdSerialNumber;
	@ExcelProperty("报销号")
	private String baoXiaoNumber;
	@ExcelProperty("单据张数")
	private String danJuNumber;
	@ExcelProperty("付款账号开户行")
	private String fdBankNo;
	@ExcelProperty("付款账号/卡号")
	private String fdBankAccount;
	@ExcelProperty("付款账号名称/卡名称")
	private String fdBankName;

	// 收款银行
	@ExcelProperty("收款账号开户行")
	private String fdRecipientBank;
	@ExcelProperty("收款地区")
	private String fdRecipientAdress;
	@ExcelProperty("收款银行人行行号")
	private String fdRecipientBankCode;
	@ExcelProperty("汇款方式")
	private String payType;
	@ExcelProperty("收款账号")
	private String fdPayeeAccount;
	@ExcelProperty("收款账号名称")
	private String fdPayeeName;
	@ExcelProperty("金额")
	private String fdMoney;
	@ExcelProperty("汇款用途")
	private String fdRemittancePurpose;
	@ExcelProperty("备注信息")
	private String fdCoverRemark;
	@ExcelProperty("收款账户短信通知手机号码")
	private String fdEmpPhone;
}
