/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 原表表头与配置关联表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class MTitleConfigVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 结算主体id
	 */
	@NotBlank(message = "结算主体id 不能为空")
	@Length(max = 32, message = "结算主体id 不能超过32 个字符")
	@ExcelAttribute(name = "结算主体id", isNotEmpty = true, errorInfo = "结算主体id 不能为空", maxLength = 32)
	@Schema(description = "结算主体id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算主体id")
	private String settleId;
	/**
	 * 结算主体
	 */
	@Length(max = 32, message = "结算主体 不能超过32 个字符")
	@ExcelAttribute(name = "结算主体", maxLength = 32)
	@Schema(description = "结算主体")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算主体")
	private String settleName;
	/**
	 * 结算主体
	 */
	@Length(max = 32, message = "结算主体 不能超过32 个字符")
	@ExcelAttribute(name = "结算主体", maxLength = 32)
	@Schema(description = "结算主体")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("结算主体")
	private String settleNo;
	/**
	 * 原表表头
	 */
	@NotBlank(message = "原表表头 不能为空")
	@Length(max = 50, message = "原表表头 不能超过50 个字符")
	@ExcelAttribute(name = "原表表头", isNotEmpty = true, errorInfo = "原表表头 不能为空", maxLength = 50)
	@Schema(description = "原表表头")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("原表表头")
	private String excelTitle;
	/**
	 * 配置id
	 */
	@NotBlank(message = "配置id 不能为空")
	@Length(max = 32, message = "配置id 不能超过32 个字符")
	@ExcelAttribute(name = "配置id", isNotEmpty = true, errorInfo = "配置id 不能为空", maxLength = 32)
	@Schema(description = "配置id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("配置id")
	private String configId;
	/**
	 * 配置名称
	 */
	@Length(max = 32, message = "配置名称 不能超过32 个字符")
	@ExcelAttribute(name = "配置名称", maxLength = 32)
	@Schema(description = "配置名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("配置名称")
	private String configName;

	/**
	 * 保存类型：0:保存；1不保存
	 */
	@ExcelAttribute(name = "保存类型：0:保存；1不保存")
	@Schema(description = "保存类型：0:保存；1不保存")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("保存类型：0:保存；1不保存")
	private Integer saveType;

}
