/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 统计-本期申报-回盘数据
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TStatisticsCurrentReportMarketVo implements Serializable {

	@ExcelAttribute(name = "行号")
	private Integer rowIndex;

	/**
	 * 税务主体(封面抬头)
	 */
	@NotBlank(message = "封面抬头全称不能为空")
	@Length(max = 50, message = "封面抬头全称 不能超过50 个字符")
	@ExcelAttribute(name = "封面抬头全称", maxLength = 50, isNotEmpty = true, errorInfo = "封面抬头全称不能为空")
	@Schema(description = "封面抬头全称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("封面抬头全称")
	private String invoiceTitle;

	/**
	 * 姓名
	 */
	@Length(max = 50, message = "姓名 不能超过50 个字符")
	@ExcelAttribute(name = "姓名", maxLength = 50)
	@Schema(description = "姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 证件类型
	 */
	@Length(max = 32, message = "证件类型不能超过32 个字符")
	@ExcelAttribute(name = "证件类型", maxLength = 32)
	@Schema(description = "证件类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("证件类型")
	private String empIdcardType;
	/**
	 * 身份证号
	 */
	@Length(max = 25, message = "证照号码 不能超过25 个字符")
	@ExcelAttribute(name = "证照号码", maxLength = 25)
	@Schema(description = "证照号码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("证照号码")
	private String empIdcard;
	/**
	 * 税款所属期起
	 */
	@Length(max = 20, message = "税款所属期起 不能超过20 个字符")
	@ExcelAttribute(name = "税款所属期起", maxLength = 20)
	@Schema(description = "税款所属期起")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税款所属期起")
	private String createStart;
	/**
	 * 税款所属期止
	 */
	@Length(max = 20, message = "税款所属期止 不能超过20 个字符")
	@ExcelAttribute(name = "税款所属期止", maxLength = 20)
	@Schema(description = "税款所属期止")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税款所属期止")
	private String createEnd;
	/**
	 * 所得项目
	 */
	@Length(max = 20, message = "所得项目 不能超过20 个字符")
	@ExcelAttribute(name = "所得项目", maxLength = 20)
	@Schema(description = "所得项目")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("所得项目")
	private String item;
	/**
	 * 本期收入
	 */
	@ExcelAttribute(name = "本期收入", maxLength = 12)
	@Schema(description = "本期收入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期收入")
	private BigDecimal realSalary;
	/**
	 * 本期费用
	 */
	@ExcelAttribute(name = "本期费用", maxLength = 12)
	@Schema(description = "本期费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期费用")
	private BigDecimal currentExpenses;
	/**
	 * 本期免税收入
	 */
	@ExcelAttribute(name = "本期免税收入", maxLength = 12)
	@Schema(description = "本期免税收入")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期免税收入")
	private BigDecimal currentTaxFreeIncome;
	/**
	 * 本期基本养老保险费
	 */
	@ExcelAttribute(name = "本期基本养老保险费", maxLength = 12)
	@Schema(description = "本期基本养老保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期基本养老保险费")
	private BigDecimal personalPensionMoney;
	/**
	 * 本期基本医疗
	 */
	@ExcelAttribute(name = "本期基本医疗保险费", maxLength = 12)
	@Schema(description = "本期基本医疗保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期基本医疗保险费")
	private BigDecimal personalMedicalMoney;
	/**
	 * 本期失业
	 */
	@ExcelAttribute(name = "本期失业保险费", maxLength = 12)
	@Schema(description = "本期失业保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期失业保险费")
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 本期住房公积金
	 */
	@ExcelAttribute(name = "本期住房公积金", maxLength = 12)
	@Schema(description = "本期住房公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期住房公积金")
	private BigDecimal personalProvidentFee;
	/**
	 * 本期企业(职业)年金
	 */
	@ExcelAttribute(name = "本期企业(职业)年金", maxLength = 12)
	@Schema(description = "本期企业(职业)年金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期企业(职业)年金")
	private BigDecimal enterpriseAnnuity;
	/**
	 * 本期商业健康保险费
	 */
	@ExcelAttribute(name = "本期商业健康保险费", maxLength = 12)
	@Schema(description = "本期商业健康保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期商业健康保险费")
	private BigDecimal nowTakingRisks;
	/**
	 * 本期税延养老保险费
	 */
	@ExcelAttribute(name = "本期税延养老保险费", maxLength = 12)
	@Schema(description = "本期税延养老保险费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期税延养老保险费")
	private BigDecimal nowTaxDeferred;
	/**
	 * 本期其他扣除(其他)
	 */
	@ExcelAttribute(name = "本期其他扣除(其他)", maxLength = 12)
	@Schema(description = "本期其他扣除(其他)")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("本期其他扣除(其他)")
	private BigDecimal nowOther;
	/**
	 * 累计收入额
	 */
	@ExcelAttribute(name = "累计收入额", maxLength = 12)
	@Schema(description = "累计收入额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计收入额")
	private BigDecimal allIncome;
	/**
	 * 累计减除费用
	 */
	@ExcelAttribute(name = "累计减除费用", maxLength = 12)
	@Schema(description = "累计减除费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计减除费用")
	private BigDecimal costReduction;
	/**
	 * 累计专项扣除
	 */
	@ExcelAttribute(name = "累计专项扣除", maxLength = 12)
	@Schema(description = "累计专项扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计专项扣除")
	private BigDecimal specialDeduction;
	/**
	 * 累计子女教育支出扣除
	 */
	@ExcelAttribute(name = "累计子女教育支出扣除", maxLength = 12)
	@Schema(description = "累计子女教育支出扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计子女教育支出扣除")
	private BigDecimal childEduinfoMoney;
	/**
	 * 累计继续教育支出扣除
	 */
	@ExcelAttribute(name = "累计继续教育支出扣除", maxLength = 12)
	@Schema(description = "累计继续教育支出扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计继续教育支出扣除")
	private BigDecimal continuingEducationExpenseMoney;
	/**
	 * 累计住房贷款利息支出扣除
	 */
	@ExcelAttribute(name = "累计住房贷款利息支出扣除", maxLength = 12)
	@Schema(description = "累计住房贷款利息支出扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房贷款利息支出扣除")
	private BigDecimal housingLoanInterestExpenseMoney;
	/**
	 * 累计住房租金支出扣除
	 */
	@ExcelAttribute(name = "累计住房租金支出扣除", maxLength = 12)
	@Schema(description = "累计住房租金支出扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计住房租金支出扣除")
	private BigDecimal housingRentalinfoMoney;
	/**
	 * 累计赡养老人支出扣除
	 */
	@ExcelAttribute(name = "累计赡养老人支出扣除", maxLength = 12)
	@Schema(description = "累计赡养老人支出扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计赡养老人支出扣除")
	private BigDecimal supportElderlyExpenseMoney;
	/**
	 * 累计3岁以下婴幼儿照护
	 */
	@ExcelAttribute(name = "累计3岁以下婴幼儿照护", maxLength = 12)
	@Schema(description = "累计3岁以下婴幼儿照护")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计3岁以下婴幼儿照护")
	private BigDecimal sumBabyMoney;

	@ExcelAttribute(name = "累计个人养老金", isFloat = true,max = "999999999.99")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "累计个人养老金")
	private BigDecimal sumPrivatePension;
	/**
	 * 累计其他扣除
	 */
	@ExcelAttribute(name = "累计其他扣除", maxLength = 12)
	@Schema(description = "累计其他扣除")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计其他扣除")
	private BigDecimal allOther;
	/**
	 * 累计准予扣除的捐赠
	 */
	@ExcelAttribute(name = "累计准予扣除的捐赠", maxLength = 12)
	@Schema(description = "累计准予扣除的捐赠")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计准予扣除的捐赠")
	private BigDecimal allDonate;
	/**
	 * 累计应纳税所得额
	 */
	@ExcelAttribute(name = "累计应纳税所得额", maxLength = 12)
	@Schema(description = "累计应纳税所得额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应纳税所得额")
	private BigDecimal taxable;
	/**
	 * 税率
	 */
	@ExcelAttribute(name = "税率", maxLength = 12)
	@Schema(description = "税率")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("税率")
	private BigDecimal taxFee;
	/**
	 * 速算扣除数
	 */
	@ExcelAttribute(name = "速算扣除数", maxLength = 12)
	@Schema(description = "速算扣除数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("速算扣除数")
	private BigDecimal quickDeducation;
	/**
	 * 累计应纳税额
	 */
	@ExcelAttribute(name = "累计应纳税额", maxLength = 12)
	@Schema(description = "累计应纳税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应纳税额")
	private BigDecimal salaryTax;
	/**
	 * 累计减免税额
	 */
	@ExcelAttribute(name = "累计减免税额", maxLength = 12)
	@Schema(description = "累计减免税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计减免税额")
	private BigDecimal allTaxDeduction;
	/**
	 * 累计应扣缴税额
	 */
	@ExcelAttribute(name = "累计应扣缴税额", maxLength = 12)
	@Schema(description = "累计应扣缴税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应扣缴税额")
	private BigDecimal allWithholdingTax;
	/**
	 * 累计已预缴税额
	 */
	@ExcelAttribute(name = "累计已预缴税额", maxLength = 12)
	@Schema(description = "累计已预缴税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计已预缴税额")
	private BigDecimal allTaxPrepaid;
	/**
	 * 累计应补(退)税额
	 */
	@ExcelAttribute(name = "累计应补(退)税额", maxLength = 12)
	@Schema(description = "累计应补(退)税额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计应补(退)税额")
	private BigDecimal allTaxPayable;
	/**
	 * 备注
	 */
	@Length(max = 255, message = "备注 不能超过255 个字符")
	@ExcelAttribute(name = "备注", maxLength = 255)
	@Schema(description = "备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备注")
	private String remark;

}
