package com.yifu.cloud.plus.v1.yifu.salary.config;

import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

import java.util.Collections;

/**
 * CORS资源共享配置
 *
 */
@Configuration
public class CorsConfig {

	@Bean
	public FilterRegistrationBean filterRegistrationBean() {
		CorsConfiguration corsConfiguration = new CorsConfiguration();
		//1.允许任何来源
		corsConfiguration.setAllowedOriginPatterns(Collections.singletonList("*"));
		//2.允许任何请求头
		corsConfiguration.addAllowedHeader(CorsConfiguration.ALL);
		//3.允许任何方法
		corsConfiguration.addAllowedMethod(CorsConfiguration.ALL);
		//4.允许凭证
		corsConfiguration.setAllowCredentials(true);

		UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
		source.registerCorsConfiguration("/**", corsConfiguration);
		CorsFilter corsFilter = new CorsFilter(source);

		FilterRegistrationBean<CorsFilter> filterRegistrationBean=new FilterRegistrationBean<>(corsFilter);
		// 前Spring Security 过滤器是通过 SecurityFilterAutoConfiguration 的 DelegatingFilterProxyRegistrationBean 注册到 servletContext上下文，其中过滤器的顺序属性 Order 读取的 是 SecurityProperties 的默认配置也就是 -100；
		filterRegistrationBean.setOrder(-101);  // 小于 SpringSecurity Filter的 Order(-100) 即可

		return filterRegistrationBean;
	}
}
