/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentInfo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.vo.TAutoPaymentInfoSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 自动化实缴记录表
 *
 * @author fxj
 * @date 2024-05-24 10:56:42
 */
public interface TAutoPaymentInfoService extends IService<TAutoPaymentInfo> {
	/**
	 * 自动化实缴记录表简单分页查询
	 *
	 * @param tAutoPaymentInfo 自动化实缴记录表
	 * @return
	 */
	IPage<TAutoPaymentInfo> getTAutoPaymentInfoPage(Page<TAutoPaymentInfo> page, TAutoPaymentInfoSearchVo tAutoPaymentInfo);

	R<List<ErrorMessage>> importDiy(InputStream inputStream);

	void listExport(HttpServletResponse response, TAutoPaymentInfoSearchVo searchVo);

	List<TAutoPaymentInfo> noPageDiy(TAutoPaymentInfoSearchVo searchVo);

	/**
	 * @Description: 获取当前月的主表
	 * @Author: hgw
	 * @Date: 2024/6/4 16:12
	 * @return: com.yifu.cloud.plus.v1.yifu.social.entity.TAutoPaymentInfo
	 **/
	TAutoPaymentInfo getThisMonthMainAuto();

	/**
	 * @param parentId
	 * @Description: 复核发起时，清空url
	 * @Author: hgw
	 * @Date: 2024/6/7 17:30
	 * @return: void
	 **/
	void setUrlToNullByRePayment(String parentId);

}
