/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 档案导出限定表（限定后不可导出，除非清理掉数据或等10分钟）
 *
 * @author hgw
 * @date 2024-10-24 15:22:51
 */
@Data
@TableName("t_archives_export_limit")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "档案导出限定表（限定后不可导出，除非清理掉数据或等10分钟）")
public class TArchivesExportLimit extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;

	/**
	 * 删除标志：0未删除；1已删除（1代表已完成导出，释放了锁）
	 */
	@ExcelAttribute(name = "删除标志：0未删除；1已删除（1代表已完成导出，释放了锁）", isNotEmpty = true, errorInfo = "删除标志：0未删除；1已删除（1代表已完成导入或删除，释放了锁）不能为空")
	@NotBlank(message = "删除标志：0未删除；1已删除（1代表已完成导出，释放了锁）不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("删除标志：0未删除；1已删除（1代表已完成导出，释放了锁）")
	private Integer deleteFlag;

	/**
	 * 类型：1预入职导出；2完整度监控导出
	 */
	@ExcelAttribute(name = "类型", isNotEmpty = true, errorInfo = "类型：1预入职导出；2完整度监控导出不能为空")
	@NotBlank(message = "类型：1预入职导出；2完整度监控导出不能为空")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：1预入职导出；2完整度监控导出")
	private Integer type;

	@Length(max = 64, message = "进度条不能超过64个字符")
	@Schema(description = "进度条")
	private String progressBar;

}
