/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 导入-瓜子offer信息接收表
 *
 * @author hgw
 * @date 2025-6-16 17:37:47
 */
@Data
public class TGzOfferInfoImportVo extends RowIndex implements Serializable {


	@ExcelAttribute(name = "人员类别编码", maxLength = 2)
	private String empType;

	@ExcelAttribute(name = "人员类别名称", maxLength = 32)
	private String empTypeDescr;

	/**
	 * 外签类型：A： 洼地外签/ B：属地外签
	 */
	@ExcelAttribute(name = "外签类型", maxLength = 2)
	private String outSginType;

	/**
	 * 合同公司主体：公司信息表
	 */
	@ExcelAttribute(name = "合同公司主体", maxLength = 20)
	private String company;

	@ExcelAttribute(name = "姓名", maxLength = 50)
	private String name;
	@ExcelAttribute(name = "姓名拼音", maxLength = 100)
	private String nameAc;
	@ExcelAttribute(name = "姓氏拼音", maxLength = 50)
	private String lastNameAc;
	@ExcelAttribute(name = "名字拼音", maxLength = 50)
	private String firstNameAc;

	@ExcelAttribute(name = "国籍编码", maxLength = 10)
	private String country;
	@ExcelAttribute(name = "国籍描述", maxLength = 30)
	private String countryDescr;
	@ExcelAttribute(name = "证件类型编码", maxLength = 6)
	private String nationalIdType;
	@ExcelAttribute(name = "证件类型描述", maxLength = 30)
	private String nationalIdTypeDescr;
	@ExcelAttribute(name = "证件号码", maxLength = 50)
	private String nationalId;

	@ExcelAttribute(name = "性别", maxLength = 10)
	private String sex;
	@ExcelAttribute(name = "个人手机号", maxLength = 30)
	private String phone;
	@ExcelAttribute(name = "个人邮箱", maxLength = 100)
	private String email;
	@ExcelAttribute(name = "直接上级姓名", maxLength = 200)
	private String supervisorName;
	@ExcelAttribute(name = "职务描述", maxLength = 50)
	private String jobcodeDescr;
	@ExcelAttribute(name = "工作地点", maxLength = 12)
	private String workLocation;
	@ExcelAttribute(name = "工作地点描述", maxLength = 12)
	private String workLocationDescr;
	/**
	 * 预计入职日期：yyyy-MM-dd
	 */
	@ExcelAttribute(name = "预计入职日期", isDate = true)
	private Date expEntryDate;
	@ExcelAttribute(name = "部门名称", maxLength = 200)
	private String deptName;
	/**
	 * 基本工资,两位小数
	 */
	@ExcelAttribute(name = "基本工资")
	private BigDecimal basePay;
	/**
	 * 绩效工资,两位小数
	 */
	@ExcelAttribute(name = "绩效工资")
	private BigDecimal perfomPay;
	@ExcelAttribute(name = "年终奖月数")
	private Integer yearBonusMonth;
	@ExcelAttribute(name = "社保缴纳地编码", maxLength = 12)
	private String socialInsuranceLocation;
	@ExcelAttribute(name = "社保缴纳地", maxLength = 30)
	private String socialInsuranceLocationDescr;
	@ExcelAttribute(name = "社保基数")
	private BigDecimal socialInsuranceBase;
	@ExcelAttribute(name = "公积金基数")
	private BigDecimal houseAccFundBaseMax;
	/**
	 * 是否转正后缴纳公积金(Y:是 N:否)
	 */
	@ExcelAttribute(name = "是否转正后缴纳公积金", maxLength = 1)
	private String beRegularEmpPay;
	@ExcelAttribute(name = "申请人邮箱", maxLength = 60)
	private String applyUserEmail;

}
