/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzEmpInfo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzEmpInfoSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 瓜子档案表
 *
 * @author chenyx
 * @date 2025-06-13 15:19:03
 */
public interface TGzEmpInfoService extends IService<TGzEmpInfo> {
	/**
	 * 瓜子档案表简单分页查询
	 *
	 * @param tGzEmpInfo 瓜子档案表
	 * @return
	 */
	IPage<TGzEmpInfo> getTGzEmpInfoPage(Page<TGzEmpInfo> page, TGzEmpInfoSearchVo tGzEmpInfo);

	void listExport(HttpServletResponse response, TGzEmpInfoSearchVo searchVo);

	List<TGzEmpInfo> noPageDiy(TGzEmpInfoSearchVo searchVo);

	/**
	 * 通过OfferId查询瓜子档案详情
	 *
	 * @param offerId OfferId
	 * @return R
	 */
	R<TGzEmpInfoSearchVo> getInfoByOfferId(Integer offerId);
}
