package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.HcmInitRoleInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprPermissionProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * @Author huyc
 * @Date 2024-01-31
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprPermissionProperties.class)
public class PermissionDaprUtil {

	@Autowired
	private DaprPermissionProperties daprProperties;

	/**
	 * @Author huyc
	 * @Description 新增用户初始化角色信息
	 * @Date 2024/1/31
	 * @Param
	 * @return
	 **/
	public void saveSysUserRole(HcmInitRoleInfoVo infoVo) {
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/sysuserroleres/inner/saveSysUserRole", JSON.toJSONString(infoVo), Object.class, SecurityConstants.FROM_IN);
	}
}
