package com.yifu.cloud.plus.v1.yifu.ekp.util;

import cn.hutool.json.JSONObject;
import com.yifu.cloud.plus.v1.yifu.ekp.config.EkpSalaryProperties;
import com.yifu.cloud.plus.v1.yifu.ekp.constant.EkpConstants;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryBackParam;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParam;
import io.micrometer.core.instrument.util.StringUtils;
import lombok.extern.log4j.Log4j2;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/**
 * @Author fxj
 * @Date 2022/7/11
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(EkpSalaryProperties.class)
public class EkpSalaryUtil {
	@Autowired
	private EkpSalaryProperties ekpProperties;

	public String sendToEKP(EkpSalaryParam param){
		log.info("推送EKP开始--薪资明细数据");
		RestTemplate yourRestTemplate = new RestTemplate();
		try{
			String formValues = new ObjectMapper().writeValueAsString(param);
			//指向EKP的接口url
			//把ModelingAppModelParameterAddForm转换成MultiValueMap
			JSONObject loginName = new JSONObject();
			loginName.append("LoginName",ekpProperties.getLoginName());
			MultiValueMap<String,Object> wholeForm = new LinkedMultiValueMap<>();
			wholeForm.add("docSubject",ekpProperties.getDocSubject());
			wholeForm.add("docCreator", "{\"LoginName\":\"admin\"}");
			wholeForm.add("docStatus", ekpProperties.getDocStatus());
			wholeForm.add("fdModelId", ekpProperties.getFdModelId());
			wholeForm.add("fdFlowId", ekpProperties.getFdFlowId());
			wholeForm.add("formValues", formValues);
			HttpHeaders headers = new HttpHeaders();
			//如果EKP对该接口启用了Basic认证，那么客户端需要加入
			//addAuth(headers,"yourAccount"+":"+"yourPassword");是VO，则使用APPLICATION_JSON
			headers.setContentType(MediaType.MULTIPART_FORM_DATA);
			//必须设置上传类型，如果入参是字符串，使用MediaType.TEXT_PLAIN；如果
			HttpEntity<MultiValueMap<String,Object>> entity = new HttpEntity<>(wholeForm,headers);
			//有返回值的情况 VO可以替换成具体的JavaBean
			ResponseEntity<String> obj = yourRestTemplate.exchange(ekpProperties.getUrl(), HttpMethod.POST, entity, String.class);
			String body = obj.getBody();
			if (StringUtils.isBlank(body)){
				log.error(EkpConstants.SEND_FAILED);
				return EkpConstants.SEND_FAILED;
			}else{
				log.info(EkpConstants.SEND_SUCCESS+body);
				return body;
			}
		}catch (Exception e){
			log.info(e.getMessage());
			return e.getMessage();
		}
	}

	// 推送主表到ekp
	public String sendStandardToEKP(String loginName, String param){
		log.info("推送EKP开始--薪资主表数据");
		RestTemplate yourRestTemplate = new RestTemplate();
		try{
			//指向EKP的接口url
			//把ModelingAppModelParameterAddForm转换成MultiValueMap
			//String formValues = new ObjectMapper().writeValueAsString(param)
			MultiValueMap<String,Object> wholeForm = new LinkedMultiValueMap<>();
			wholeForm.add("docSubject",ekpProperties.getDocSubject());
			wholeForm.add("docCreator", "{\"LoginName\":\"" + loginName+ "\"}");
			wholeForm.add("docStatus", ekpProperties.getDocStatus());
			wholeForm.add("formValues", param);
			wholeForm.add("fdModelId", ekpProperties.getStandardFdModelId());
			wholeForm.add("fdFlowId", ekpProperties.getStandardFdFlowId());
			HttpHeaders headers = new HttpHeaders();
			//如果EKP对该接口启用了Basic认证，那么客户端需要加入
			//addAuth(headers,"yourAccount"+":"+"yourPassword");是VO，则使用APPLICATION_JSON
			headers.setContentType(MediaType.MULTIPART_FORM_DATA);
			//必须设置上传类型，如果入参是字符串，使用MediaType.TEXT_PLAIN；如果
			HttpEntity<MultiValueMap<String,Object>> entity = new HttpEntity<>(wholeForm,headers);
			//有返回值的情况 VO可以替换成具体的JavaBean
			ResponseEntity<String> obj = yourRestTemplate.exchange(ekpProperties.getUrl(), HttpMethod.POST, entity, String.class);
			String body = obj.getBody();
			if (StringUtils.isBlank(body)){
				log.error(EkpConstants.SEND_FAILED);
				return EkpConstants.SEND_FAILED;
			}else{
				log.info(EkpConstants.SEND_SUCCESS+body);
				return body;
			}
		}catch (Exception e){
			log.info(e.getMessage());
			return e.getMessage();
		}
	}

	// 退表到ekp
	public String backStandardToEKP(EkpSalaryBackParam param){
		log.info("推送EKP开始--薪资退表");
		RestTemplate yourRestTemplate = new RestTemplate();
		try{
			//指向EKP的接口url
			//把ModelingAppModelParameterAddForm转换成MultiValueMap
			MultiValueMap<String,Object> wholeForm = new LinkedMultiValueMap<>();
			wholeForm.add("docSubject",ekpProperties.getDocSubject());
			wholeForm.add("docCreator", "{\"LoginName\":\"admin\"}");
			wholeForm.add("docStatus", ekpProperties.getDocStatus());
			String formValues = new ObjectMapper().writeValueAsString(param);
			wholeForm.add("formValues", formValues);
			wholeForm.add("fdModelId", ekpProperties.getBackSalaryFdModelId());
			wholeForm.add("fdFlowId", ekpProperties.getBackSalaryFdFlowId());
			HttpHeaders headers = new HttpHeaders();
			//如果EKP对该接口启用了Basic认证，那么客户端需要加入
			//addAuth(headers,"yourAccount"+":"+"yourPassword");是VO，则使用APPLICATION_JSON
			headers.setContentType(MediaType.MULTIPART_FORM_DATA);
			//必须设置上传类型，如果入参是字符串，使用MediaType.TEXT_PLAIN；如果
			HttpEntity<MultiValueMap<String,Object>> entity = new HttpEntity<>(wholeForm,headers);
			//有返回值的情况 VO可以替换成具体的JavaBean
			ResponseEntity<String> obj = yourRestTemplate.exchange(ekpProperties.getUrl(), HttpMethod.POST, entity, String.class);
			String body = obj.getBody();
			if (StringUtils.isBlank(body)){
				log.error(EkpConstants.SEND_FAILED);
				return EkpConstants.SEND_FAILED;
			}else{
				log.info(EkpConstants.SEND_SUCCESS+body);
				return body;
			}
		}catch (Exception e){
			log.info(e.getMessage());
			return e.getMessage();
		}
	}

}
