package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TMinSalary;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TMinSalaryExportVo;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TMinSalarySearchVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoBatchVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TPaymentInfoSearchVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 各地市最低工资标准
 *
 * @author fxj
 * @date 2022-08-06 13:00
 */
@Mapper
public interface TMinSalaryMapper extends BaseMapper<TMinSalary> {
  /**
    * 各地市最低工资标准简单分页查询
    * @param tMinSalary 各地市最低工资标准
    * @return
    */
  IPage<TMinSalary> getTMinSalaryPage(Page page, @Param("tMinSalary") TMinSalarySearchVo tMinSalary);


	/**
	 * 最低工资分页列表总数
	 * @param tMinSalary 最低工资标准
	 * @return
	 */
	Integer selectCountTMinSalary(@Param("tMinSalary") TMinSalarySearchVo tMinSalary);


	/**
	 * 不分页查询
	 *
	 * @author wzb
	 * @param tMinSalary
	 * @return {@link List< TMinSalaryExportVo>}
	 */
	 List<TMinSalaryExportVo>getTMinSalaryNoPage(@Param("tMinSalary") TMinSalarySearchVo tMinSalary);

    /**
     * TODO
     *
     * @author wzb
     * @param areaName
     * @return {@link Integer}
     */
	Integer selectByAreaName(String areaName);

	Integer selectByPName(Integer id);
	Integer selectByCName(Integer id);
	Integer selectByTName(Integer id);
	Integer selectId(String Id);
	TMinSalary selectAddress();
}
