/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.admin.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;


/**
 * 外部字典值数据表
 *
 * @author chenyx
 * @date 2025-06-11 15:57:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("sys_out_rel_dict_item")
@Schema(description = "外部字典值数据表")
public class SysOutRelDictItem extends Model<SysOutRelDictItem> {

	/**
	 * 字典值ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "字典值ID")
	private Long id;
	/**
	 * 外部端所属字典类型
	 */
	@Length(max = 100, message = "外部端所属字典类型不能超过128个字符")
	@Schema(description = "外部端所属字典类型")
	private String dictType;
	/**
	 * 外部端字典值value
	 */
	@Length(max = 100, message = "外部端字典值value不能超过20个字符")
	@Schema(description = "外部端字典值value")
	private String value;
	/**
	 * 对照皖信所属字典类型
	 */
	@Schema(description = "对照皖信所属字典类型")
	private String sysDictType;
	/**
	 * 对照皖信字典值
	 */
	@Schema(description = "对照皖信字典值")
	private String sysDictValue;
	/**
	 * 外部端标识（gz：瓜子）
	 */
	@Length(max = 32, message = "外部端标识（gz：瓜子）不能超过32个字符")
	@Schema(description = "外部端标识（gz：瓜子）")
	private String clientId;

}
