package com.yifu.cloud.plus.v1.business.entity.system;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import java.util.List;


/**
 * B端预警表
 *
 * @author hgw
 * @date 2021-08-20 17:39:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_bus_warning")
@Schema(description = "B端预警表")
public class TBusWarning extends Model<TBusWarning> {
     private static final long serialVersionUID = 1L;
     /**
      *
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;
     /**
      * 类型：0短信；1系统消息
      */
     @ExcelAttribute(name = "类型：0短信；1系统消息")
     @Schema(description = "类型：0短信；1系统消息")
     private Integer type;
     /**
      * 提醒类型：0复审；1到期；2年假未休；3假期结束日期
      */
     @ExcelAttribute(name = "提醒类型：0复审；1到期；2年假未休；3假期结束日期")
     @Schema(description = "提醒类型：0复审；1到期；2年假未休；3假期结束日期")
     private Integer remindType;
     /**
      * 模板
      */
     @Length(max = 100, message = "模板不能超过100个字符")
     @ExcelAttribute(name = "模板", maxLength = 100)
     @Schema(description = "模板")
     private String remindTemplate;
     /**
      * 发送方式：0自动；1手动
      */
     @ExcelAttribute(name = "发送方式：0自动；1手动")
     @Schema(description = "发送方式：0自动；1手动")
     private Integer sendMethod;
     /**
      * 提醒规则（到期天数）
      */
     @ExcelAttribute(name = "提醒规则（到期天数）")
     @Schema(description = "提醒规则（到期天数）")
     private Integer remindRules;
     /**
      * 提醒对象（为空，则提醒到人，否则为角色idStr，逗号分隔）
      */
     @Length(max = 50, message = "提醒对象（为空，则提醒到人，否则为角色idStr，逗号分隔）不能超过50个字符")
     @ExcelAttribute(name = "提醒对象（为空，则提醒到人，否则为角色idStr，逗号分隔）", maxLength = 50)
     @Schema(description = "提醒对象（为空，则提醒到人，否则为角色idStr，逗号分隔）")
     private String remindObject;

     /**
      * 模板编码
      */
     @Length(max = 20, message = "模板编码不能超过20个字符")
     @ExcelAttribute(name = "模板编码", maxLength = 20)
     @Schema(description = "模板编码", name = "modelCode")
     private String modelCode;

     /**
      * 签名（例：安徽皖信）
      */
     @Length(max = 32, message = "签名不能超过32个字符")
     @ExcelAttribute(name = "签名", maxLength = 32)
     @Schema(description = "签名（例：安徽皖信）", name = "signName")
     private String signName;

     /**
      * 年假未休的发送日期（设计初始日期为'06-30'
      */
     @Length(max = 10, message = "年假未休的发送日期不能超过10个字符")
     @ExcelAttribute(name = "年假未休的发送日期", maxLength = 10)
     @Schema(description = "年假未休的发送日期", name = "sendDate")
     private String sendDate;

     /**
      * 备注
      */
     @Schema(description = "备注", name = "remark")
     private String remark;

     /**
      * 人员列表
      **/
     @TableField(exist = false)
     private List<TBusWarningEmployee> empList;

}
