/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.check.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银行卡卡号 校验
 *
 * @author fxj
 * @date 2022-06-20 19:56:33
 */
@Data
@TableName("t_check_bank_no")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "银行卡卡号 校验")
public class TCheckBankNo extends BaseEntity {

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="id")
    private String id;

    /**
     * 创建人姓名
     */
    @Schema(description ="创建人姓名")
    private String createName;

    /**
     * 0:初始数据 1：API验证结果
     */
    @Schema(description ="0:初始数据 1：API验证结果")
    private String type;

    /**
     * 响应code码解释
     */
    @Schema(description ="响应code码解释")
    private String message;

    /**
     * 样例：信息认证未通过(验证不一致)
     */
    @Schema(description ="样例：信息认证未通过(验证不一致)")
    private String remark;

    /**
     * 	认证结果:
	 * 01	一致
	 * 02	不一致
	 * 03	认证不确定
	 * 04	认证失败
     */
    @Schema(description ="	认证结果")
    private String result;

    /**
     * 所属银行。样例：招商银行
     */
    @Schema(description ="所属银行。样例：招商银行")
    private String bankName;

	/**
	 * 银行卡号
	 */
	@Schema(description ="银行卡号")
	private String bankNo;


    /**
     * 银行卡类型
     */
    @Schema(description ="银行卡类型")
    private String cardType;

    /**
     * 银行卡类别 样例：借记卡
     */
    @Schema(description ="银行卡类别 样例：借记卡")
    private String cardCategory;

	/**
	 * 姓名
	 */
	@Schema(description ="姓名")
	private String name;

	/**
	 * 身份证
	 */
	@Schema(description ="身份证")
	private String idNum;

	/**
	 * 手机号码
	 */
	@TableField(exist = false)
	@Schema(description ="手机号码")
	private String mobile;


}
