/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.check.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.check.entity.TCheckMobile;
import com.yifu.cloud.plus.v1.check.vo.CheckBatchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;
import java.util.Map;

/**
 * 手机号码校验
 *
 * @author fxj
 * @date 2022-06-20 17:29:03
 */
public interface TCheckMobileService extends IService<TCheckMobile> {

	R<Map<String,TCheckMobile>> checkMobiles(String mobiles);

	TCheckMobile checkOneMobile(String mobile);

	/**
	 * @Description: 批量手机号
	 * @Author: hgw
	 * @Date: 2023/2/9 11:24
	 * @return: com.yifu.cloud.plus.v1.check.vo.CheckBatchVo
	 **/
	CheckBatchVo checkMobileBatch(List<String> list);

	/**
	 * @Description: C端预入职校验手机号使用，其他慎用
	 * @Author: hgw
	 * @Date: 2024/6/27 16:04
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> checkPrePhone(String phone, String deptId);

}
