package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2023/2/21
 * @Description
 * @Version 1.0
 */
@Schema(description = "商险备注批量操作")
@Data
public class InsurancesWarnUpdateVo  extends RowIndex implements Serializable {
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", errorInfo = "员工姓名不能为空", maxLength = 32, needExport = true)
	private String empName;
	/**
	 * 员工身份证号
	 */
	@ExcelAttribute(name = "员工身份证号码", errorInfo = "员工身份证号不能为空", maxLength = 32, needExport = true)
	private String empIdcardNo;

	/**
	 * 结算部门名称中文（内部组织架构）
	 */
	@Schema(name = "项目名称")
	@ExcelAttribute(name = "项目名称")
	private String deptName;
	/**
	 * 结算部门编码（内部组织架构）
	 */
	@Schema(name = "项目编码")
	@ExcelAttribute(name = "项目编码")
	private String deptNo;
	/**
	 * 保险公司（配置项）
	 */
	@ExcelAttribute(name = "保险公司名称", errorInfo = "保险公司（配置项）不能为空", maxLength = 32, needExport = true)
	private String insuranceCompanyName;

	/**
	 * 险种名称中文（配置项） 用于导入
	 */
	@ExcelAttribute(name = "险种名称", errorInfo = "险种名称不能为空", maxLength = 32, needExport = true)
	private String insuranceTypeName;

	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@ExcelAttribute(name = "保单开始时间", errorInfo = "保单开始时间不能为空", needExport = true)
	private String policyStart;
	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@ExcelAttribute(name = "保单结束时间", needExport = true)
	private String policyEnd;

	/**
	 * 购买标准
	 */
	@Schema(name = "购买标准")
	private String buyStandard;

	/**
	 * 到期消息提醒批量导入是否续保
	 */
	@ExcelAttribute(name = "是否续保", maxLength = 32)
	private String renewal;

	/**
	 * 备注(未续保原因)
	 */
	@ExcelAttribute(name = "备注(未续保原因)")
	private String expireRemark;
}
