package com.yifu.cloud.plus.v1.yifu.process.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;


/**
 * 主流程表
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_process")
@Schema(description = "主流程表")
public class TProcess extends Model<TProcess> {
     private static final long serialVersionUID = 1L;

     @TableId(type = IdType.ASSIGN_ID)
	 @Schema(description = "主键")
     private String id;

     @NotBlank(message = "流程名称不能为空")
     @Length(max = 255, message = "流程名称不能超过255个字符")
	 @Schema(description = "流程名称")
     private String name;

     @Length(max = 255, message = "流程标识（系统自动生成MD5串）不能超过255个字符")
	 @Schema(description = "流程标识（系统自动生成MD5串）")
     private String logoTitle;

     @NotBlank(message = "流程创建人不能为空")
     @Length(max = 255, message = "流程创建人不能超过255个字符")
	 @Schema(description = "流程创建人")
     private String createUser;

	 @Schema(description = "流程创建时间")
     private LocalDateTime createDate;

     @Length(max = 255, message = "流程更新人不能超过255个字符")
	 @Schema(description = "流程更新人")
     private String updateUser;

	 @Schema(description = "流程更新时间")
     private LocalDateTime updateDate;

     @Length(max = 255, message = "流程描述不能超过255个字符")
	 @Schema(description = "流程描述")
     private String description;

     @Length(max = 1, message = "删除表示 0未删除 1删除不能超过1个字符")
	 @Schema(description = "删除表示 0未删除 1删除")
     private String deleteFlag;

     @Length(max = 1, message = "是否通用不能超过1个字符")
	 @Schema(description = "是否通用0是1否")
     private String commonUse;

     @Length(max = 1, message = "是否在用不能超过1个字符")
	 @Schema(description = "是否在用 0在用 1历史")
     private String processIsUse;
}
