package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;


/**
 * 薪资工资条配置明细表
 *
 * @author hgw
 * @date 2021-10-08 14:36:56
 */
@Data
@TableName("t_salary_standard_set_detail")
@Tag(name = "薪资工资条配置明细表")
public class TSalaryStandardSetDetail{
     private static final long serialVersionUID = 1L;
     /**
      *
      */
     @TableId(type = IdType.ASSIGN_ID)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "主键")
     private String id;
     /**
      *TSalaryStandardSet表的主键
      */
     @NotBlank(message = "TSalaryStandardSet表的主键不能为空")
     @Length(max = 32, message = "TSalaryStandardSet表的主键不能超过32个字符")
     @ExcelAttribute(name = "TSalaryStandardSet表的主键", isNotEmpty = true, errorInfo = "不能为空", maxLength = 32)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "TSalaryStandardSet表的主键")
     private String setId;
     /**
      *
      */
     @NotBlank(message = "不能为空")
     @Length(max = 50, message = "不能超过50个字符")
     @ExcelAttribute(name = "", isNotEmpty = true, errorInfo = "不能为空", maxLength = 50)
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "")
     private String cnName;
     /**
      *
      */
     @NotNull(message = "不能为空")
     @ExcelAttribute(name = "", isNotEmpty = true, errorInfo = "不能为空")
     @HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "")
     private Integer orderLine;
}
