/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * 同步ekp薪酬信息
 *
 * @author huyc
 * @date 2023-04-18 11:40:14
 */
@Data
public class TSalaryEmployeeEkpUpdateVo implements Serializable {


	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 开户行总行
	 */
	@Schema(description = "开户行总行")
	private String bankName;
	/**
	 * 银行卡号
	 */
	@Schema(description = "银行卡号")
	private String bankNo;

}
