/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 工资EXCEL校验配置表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TSalaryExcelCheckVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "id 不能为空")
	@Length(max = 32, message = "id 不能超过32 个字符")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "id 不能为空", maxLength = 32)
	@Schema(description = "id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;
	/**
	 * 配置名称
	 */
	@Length(max = 50, message = "配置名称 不能超过50 个字符")
	@ExcelAttribute(name = "配置名称", maxLength = 50)
	@Schema(description = "配置名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("配置名称")
	private String name;
	/**
	 * 部门ID
	 */
	@NotBlank(message = "部门ID 不能为空")
	@Length(max = 32, message = "部门ID 不能超过32 个字符")
	@ExcelAttribute(name = "部门ID", isNotEmpty = true, errorInfo = "部门ID 不能为空", maxLength = 32)
	@Schema(description = "部门ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门ID")
	private String departId;
	/**
	 * 部门名称
	 */
	@Length(max = 50, message = "部门名称 不能超过50 个字符")
	@ExcelAttribute(name = "部门名称", maxLength = 50)
	@Schema(description = "部门名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门名称")
	private String departName;
	/**
	 * 部门编码
	 */
	@Length(max = 32, message = "部门编码 不能超过32 个字符")
	@ExcelAttribute(name = "部门编码", maxLength = 32)
	@Schema(description = "部门编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("部门编码")
	private String departNo;
	/**
	 * 主表列名
	 */
	@NotBlank(message = "主表列名 不能为空")
	@Length(max = 50, message = "主表列名 不能超过50 个字符")
	@ExcelAttribute(name = "主表列名", isNotEmpty = true, errorInfo = "主表列名 不能为空", maxLength = 50)
	@Schema(description = "主表列名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主表列名")
	private String mainName;
	/**
	 * 字表列名
	 */
	@Length(max = 50, message = "字表列名 不能超过50 个字符")
	@ExcelAttribute(name = "字表列名", maxLength = 50)
	@Schema(description = "字表列名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("字表列名")
	private String subName;

}
