package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author wzb
 * @description 人员退休提醒
 * @date 2023-05-18 15:11:11
 */

@Data
@TableName("t_employee_retirement")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "项目档案表")
public class TEmployeeRetirement extends BaseEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	/**
	 * 主键
	 */

	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description ="主键")
	private String id;

	/**
	 * 员工姓名
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 身份证号码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号码")
	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;

	/**
	 * 手机号码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码")
	@ExcelAttribute(name = "手机号码")
	@Schema(description = "手机号码")
	private String empPhone;

	/**
	 * 性别
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("性别")
	@ExcelAttribute(name = "性别")
	@Schema(description = "性别")
	private String empSex;

	/**
	 * 年龄
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年龄")
	@ExcelAttribute(name = "年龄")
	@Schema(description = "年龄")
	private Integer empAge;

	/**
	 * 员工类型（字典值，0外包1派遣2代理）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型")
	@ExcelAttribute(name = "员工类型")
	@Schema(description = "员工类型")
	private String empNatrue;

	/**
	 * 档案-省
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("省")
	@ExcelAttribute(name = "省")
	@Schema(description = "档案-省")
	private Integer fileProvince;

	/**
	 * 档案-市
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("市")
	@ExcelAttribute(name = "市")
	@Schema(description = "档案-市")
	private Integer fileCity;

	/**
	 * 档案-县
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("县")
	@ExcelAttribute(name = "县")
	@Schema(description = "档案-县")
	private Integer fileTown;

	/**
	 * 社保-省
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保-省")
	@ExcelAttribute(name = "社保-省")
	@Schema(description = "社保-省")
	private Integer socialProvince;

	/**
	 * 社保-市
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保-市")
	@ExcelAttribute(name = "社保-市")
	@Schema(description = "社保-市")
	private Integer socialCity;

	/**
	 * 社保-县
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保-县")
	@ExcelAttribute(name = "社保-县")
	@Schema(description = "社保-县")
	private Integer socialTown;

	/**
	 * 项目名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	@ExcelAttribute(name = "项目名称")
	@Schema(description = "项目名称")
	private String deptName;

	/**
	 * 客户名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	@ExcelAttribute(name = "客户名称")
	@Schema(description = "客户名称")
	private String unitName;

	/**
	 * 客户编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户编码")
	@ExcelAttribute(name = "客户编码")
	@Schema(description = "客户编码")
	private String unitNo;

	/**
	 * 项目编码
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	@ExcelAttribute(name = "项目编码")
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 是否处理（0未处理，1处理）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否处理")
	@ExcelAttribute(name = "是否处理")
	@Schema(description = "是否处理")
	private Integer handleFlag;




}
