/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.archives.entity.*;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 预入职详情
 *
 * @author hgw
 * @date 2024-6-17 16:43:37
 */
@Data
public class PreEmpMainDetailVo implements Serializable {

	private static final long serialVersionUID = 1L;

	// 主表
	private TPreEmpMain main;
	// 预入职-员工不良记录表
	private TPreEmpBadRecord tpreEmpBadRecord;
	// 预入职-紧急联络人
	private TPreEmpContactInfo tpreEmpContactInfo;
	// 预入职-员工声明
	private TPreEmpDeclaration tpreEmpDeclaration;
	// 预入职-员工伤残信息表
	private TPreEmpDisabilityInfo tpreEmpDisabilityInfo;
	// 预入职-员工学历信息表
	private TPreEmpEducation tpreEmpEducation;
	// 预入职-员工家庭信息表
	private List<TPreEmpFamily> tpreEmpFamilyList;
	// 预入职-人员档案表
	private TPreEmployeeInfo tpreEmployeeInfo;
	// 预入职-项目档案表
	private TPreEmployeeProject tpreEmployeeProject;
	// 预入职-员工职业资格信息表
	private List<TPreEmpProfessionalQualification> tpreEmpProfessionalQualificationList;
	// 预入职-员工工作履历信息表
	private List<TPreEmpWorkRecording> tpreEmpWorkRecordingList;
	// 预入职-9身份证 10 户口本；附件 21（预入职申明签名）；22（预入职确认签名）；23（预入职pdf文件)
	private List<TAttaInfo> attaInfoList;
	// 预入职-其他附件（因为含有与附件无关的 名称，因此需要用子表来保存它）
	private List<TPreEmpOtherFile> tpreEmpOtherFileList;

}
