/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 导出-法大大专业版模版表
 *
 * @author hgw
 * @date 2025-09-30 16:29:28
 */
@Data
@ColumnWidth(10)
public class TFascTemplateExportVo {
// 公司主体、签署方、签署方Openid、模版ID、模版名称、

	/**
	 * 公司主体
	 */
	@ExcelAttribute(name = "公司主体", maxLength = 100)
	@Length(max = 100, message = "公司主体不能超过100个字符")
	@ExcelProperty("公司主体")
	@Schema(description = "公司主体")
	private String companyName;
	/**
	 * 签署方
	 */
	@ExcelAttribute(name = "签署方", maxLength = 100)
	@Length(max = 100, message = "签署方不能超过100个字符")
	@ExcelProperty("签署方")
	@Schema(description = "签署方")
	private String signName;
	/**
	 * 签署方Openid
	 */
	@ExcelAttribute(name = "签署方Openid", maxLength = 100)
	@Length(max = 100, message = "签署方Openid不能超过100个字符")
	@ExcelProperty("签署方Openid")
	@Schema(description = "签署方Openid")
	private String signOpenId;
	/**
	 * 模版ID
	 */
	@ExcelAttribute(name = "模版ID", isNotEmpty = true, errorInfo = "模版ID不能为空", maxLength = 100)
	@NotBlank(message = "模版ID不能为空")
	@Length(max = 100, message = "模版ID不能超过100个字符")
	@ExcelProperty("模版ID")
	@Schema(description = "模版ID")
	private String signTemplateId;
	/**
	 * 模版名称
	 */
	@ExcelAttribute(name = "模版名称", maxLength = 100)
	@Length(max = 100, message = "模版名称不能超过100个字符")
	@ExcelProperty("模版名称")
	@Schema(description = "模版名称")
	private String signTemplateName;

	// 创建人、最新更新时间、关联用章名称、模版状态、是否免验证签、皖信合同类型、必填是否已配置

	/**
	 * 创建人
	 */
	@ExcelAttribute(name = "创建人", maxLength = 100)
	@Length(max = 100, message = "创建人不能超过100个字符")
	@ExcelProperty("创建人")
	@Schema(description = "创建人")
	private String creatorMemberName;
	/**
	 * 最新更新时间
	 */
	@ExcelAttribute(name = "最新更新时间", isDate = true)
	@ExcelProperty("最新更新时间")
	@Schema(description = "最新更新时间")
	private String fascUpdateTime;
	/**
	 * 关联用章名称
	 */
	@ExcelAttribute(name = "关联用章名称", maxLength = 100)
	@Length(max = 100, message = "关联用章名称不能超过100个字符")
	@ExcelProperty("关联用章名称")
	@Schema(description = "关联用章名称")
	private String zhangName;
	/**
	 * 模版状态
	 * invalid: 停用;valid: 启用;creating：草稿
	 */
	@ExcelAttribute(name = "模版状态", maxLength = 20, isDataId = true, readConverterExp = "invalid=停用,valid=启用,creating=草稿")
	@Length(max = 20, message = "模版状态不能超过20个字符")
	@ExcelProperty("模版状态")
	@Schema(description = "模版状态")
	private String signTemplateStatus;
	/**
	 * 是否免验证签0否1是
	 */
	@ExcelAttribute(name = "是否免验证签", maxLength = 1, isDataId = true, readConverterExp = "0=否,1=是")
	@Length(max = 1, message = "是否免验证签不能超过1个字符")
	@ExcelProperty("是否免验证签")
	@Schema(description = "是否免验证签")
	private String isMianQian;

	/**
	 * 皖信合同类型
	 */
	@ExcelAttribute(name = "皖信合同类型", maxLength = 32)
	@Length(max = 32, message = "皖信合同类型不能超过32个字符")
	@ExcelProperty("皖信合同类型")
	@Schema(description = "皖信合同类型")
	private String contractType;
	/**
	 * 必填是否已配置0未配置1部分配置2已配置
	 */
	@ExcelAttribute(name = "必填是否已配置", maxLength = 1, isDataId = true, readConverterExp = "0=未配置,1=部分配置,2=已配置")
	@Length(max = 1, message = "必填是否已配置不能超过1个字符")
	@ExcelProperty("必填是否已配置")
	@Schema(description = "必填是否已配置")
	private String isMustEdit;

}
