package com.yifu.cloud.plus.v1.business.dto.vacation;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description: ChangeVacationStatusDTO
 * @author: wangweiguo
 * @date: 2021/8/24
 */
@Getter
@Setter
@ToString
public class ChangeVacationStatusDTO implements Serializable {
    /**
     * 主键
     */
	@Schema(description = "主键")
	@NotNull(message = "主键不能为空")
    private String id;

    /**
     * 销假说明
     */
	@Schema(description = "销假说明")
	private String vacationNote;

    /**
     * 假勤实际结束时间
     */
	@Schema(description = "假勤实际结束时间")
	private LocalDateTime acturalVacationEndTime;
}
