package com.yifu.cloud.plus.v1.yifu.common.core.util.alisms;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: master
 * @description: 阿里云短信工具 - 安徽易服 的阿里云短信
 * @author: fang
 * @create: 2021-05-07
 **/
@Slf4j
public class YiFuSmsUtil {

	private static final String ACCESS_KEY_ID = "LTAI5t7p866qHr6p1Kuog7b1";
	private static final String ACCESS_KEY_SECRET = "tMxJt1TWtHZr9bOpe1hk7PHRg0xrmf";
    private static final String ERROR_INFO = "调取阿里云服务异常";
    private static final String REGIONID = "cn-hangzhou";
    private static final String SYS_DOMAIN = "dysmsapi.aliyuncs.com";
    private static final String SYS_VERSION = "2017-05-25";
    private static final String MESSAGE = "Message";
    private static final String CODE =  "Code";

    private YiFuSmsUtil() { throw new IllegalStateException("Utility class");}

    /**
     * 防寒、防暑、节假日短信  单条发送
     * @Author fxj
     * @Date 2021-05-07
     * @param phone
     * @param templateParam
     * @param signName
     * @param templateCode
     * @return
     * 错误示例 {"Message":"模板不合法(不存在或被拉黑)","RequestId":"D7923A5B-AE30-481C-84D4-56BB0F230848","Code":"isv.SMS_TEMPLATE_ILLEGAL"}
     * 正确结果{"Message":"OK","RequestId":"38FA1BE1-52C1-4833-9211-AD55CF264988","BizId":"342207398251524244^0","Code":"OK"}
     **/
    public static AliSmsResult sendSms(String phone,String templateParam,String signName,String templateCode){
        DefaultProfile profile = DefaultProfile.getProfile(REGIONID, ACCESS_KEY_ID, ACCESS_KEY_SECRET);
        IAcsClient client = new DefaultAcsClient(profile);
        JSONObject exceptionResult = new JSONObject();
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain(SYS_DOMAIN);
        request.setSysVersion(SYS_VERSION);
        request.setSysAction("SendSms");
        request.putQueryParameter("RegionId", REGIONID);
        request.putQueryParameter("PhoneNumbers", phone);
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", templateCode);
        request.putQueryParameter("TemplateParam", "{\"name\":\""+templateParam+"\"}");
        try {
            CommonResponse response = client.getCommonResponse(request);
            return JSON.parseObject(response.getData(),AliSmsResult.class);
        } catch (Exception e) {
            log.error(ERROR_INFO,e);
            exceptionResult.put(MESSAGE, ERROR_INFO);
            exceptionResult.put(CODE, e.getMessage());
            return exceptionResult.toJavaObject(AliSmsResult.class);
        }
    }

    /**
     * 防寒、防暑、节假日短信  批量发送
     * @Author fxj
     * @Date 2021-05-07
     * @param phones
     * @param templateParams
     * @param signNames
     * @param templateCode
     * @return
     * 错误示例 {"Message":"模板不合法(不存在或被拉黑)","RequestId":"D7923A5B-AE30-481C-84D4-56BB0F230848","Code":"isv.SMS_TEMPLATE_ILLEGAL"}
     * 正确结果{"Message":"OK","RequestId":"38FA1BE1-52C1-4833-9211-AD55CF264988","BizId":"342207398251524244^0","Code":"OK"}
     **/
    public static AliSmsResult sendBatchSms(List<String> phones,
                                            List<ParamVo>  templateParams,
                                            List<String> signNames,
                                            String templateCode){
        DefaultProfile profile = DefaultProfile.getProfile(REGIONID, ACCESS_KEY_ID, ACCESS_KEY_SECRET);
        IAcsClient client = new DefaultAcsClient(profile);
        JSONObject exceptionResult = new JSONObject();
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain(SYS_DOMAIN);
        request.setSysVersion(SYS_VERSION);
        request.setSysAction("SendBatchSms");
        request.putQueryParameter("PhoneNumberJson", JSONObject.toJSONString(phones));
        request.putQueryParameter("SignNameJson", JSONObject.toJSONString(signNames));
        request.putQueryParameter("TemplateCode", templateCode);
        request.putQueryParameter("TemplateParamJson", JSONObject.toJSONString(templateParams));
        try {
            CommonResponse response = client.getCommonResponse(request);
            return JSON.parseObject(response.getData(),AliSmsResult.class);
        } catch (Exception e) {
            log.error(ERROR_INFO,e);
            exceptionResult.put(MESSAGE, ERROR_INFO);
            exceptionResult.put(CODE, e.getMessage());
            return exceptionResult.toJavaObject(AliSmsResult.class);
        }
    }

    public static QuerySendResult querySendDetail(String phone, String bizId, String sendDate, String pageSize, String curPage){
        DefaultProfile profile = DefaultProfile.getProfile(REGIONID, ACCESS_KEY_ID, ACCESS_KEY_SECRET);
        IAcsClient client = new DefaultAcsClient(profile);
        JSONObject exceptionResult = new JSONObject();
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain(SYS_DOMAIN);
        request.setSysVersion(SYS_VERSION);
        request.setSysAction("QuerySendDetails");
        request.putQueryParameter("PhoneNumber", phone);
        request.putQueryParameter("BizId", bizId);
        request.putQueryParameter("SendDate", sendDate);
        request.putQueryParameter("PageSize", null==pageSize?"10":pageSize);
        request.putQueryParameter("CurrentPage", null ==curPage?"1":curPage);
        try {
            CommonResponse response = client.getCommonResponse(request);
            return  JSON.parseObject(response.getData(),QuerySendResult.class);
        } catch (Exception e) {
            log.error(ERROR_INFO,e);
            exceptionResult.put(MESSAGE, ERROR_INFO);
            exceptionResult.put(CODE, e.getMessage());
            return exceptionResult.toJavaObject(QuerySendResult.class);
        }
    }

	/**
	 * 入职登记信息补充提醒短信
	 * @Author huych
	 * @Date 2025-03-18
	 * @param phones
	 * @param templateParams
	 * @param signName
	 * @param templateCode
	 * @return
	 * 错误示例 {"Message":"模板不合法(不存在或被拉黑)","RequestId":"D7923A5B-AE30-481C-84D4-56BB0F230848","Code":"isv.SMS_TEMPLATE_ILLEGAL"}
	 * 正确结果{"Message":"OK","RequestId":"38FA1BE1-52C1-4833-9211-AD55CF264988","BizId":"342207398251524244^0","Code":"OK"}
	 **/
	public static AliSmsResult sendRegistBatchSms(List<String> phones,
												  List<RegistParamVo> templateParams,
												  List<String> signName,
												  String templateCode){
		DefaultProfile profile = DefaultProfile.getProfile(REGIONID, ACCESS_KEY_ID, ACCESS_KEY_SECRET);
		IAcsClient client = new DefaultAcsClient(profile);
		JSONObject exceptionResult = new JSONObject();
		CommonRequest request = new CommonRequest();
		request.setSysMethod(MethodType.POST);
		request.setSysDomain(SYS_DOMAIN);
		request.setSysVersion(SYS_VERSION);
		request.setSysAction("SendBatchSms");
		request.putQueryParameter("PhoneNumberJson", JSONObject.toJSONString(phones));
		request.putQueryParameter("SignNameJson", JSONObject.toJSONString(signName));
		request.putQueryParameter("TemplateCode", templateCode);
		request.putQueryParameter("TemplateParamJson", JSONObject.toJSONString(templateParams));
		try {
			CommonResponse response = client.getCommonResponse(request);
			return JSON.parseObject(response.getData(),AliSmsResult.class);
		} catch (Exception e) {
			log.error(ERROR_INFO,e);
			exceptionResult.put(MESSAGE, ERROR_INFO);
			exceptionResult.put(CODE, e.getMessage());
			return exceptionResult.toJavaObject(AliSmsResult.class);
		}
	}
	public static Map<String,SmsSendDetailDTO> querySendDetails(List<String> phones, String bizId, String sendDate, String pageSize, String curPage){
        DefaultProfile profile = DefaultProfile.getProfile(REGIONID, ACCESS_KEY_ID, ACCESS_KEY_SECRET);
        IAcsClient client = new DefaultAcsClient(profile);
        JSONObject exceptionResult = new JSONObject();
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain(SYS_DOMAIN);
        request.setSysVersion(SYS_VERSION);
        request.setSysAction("QuerySendDetails");
        request.putQueryParameter("BizId", bizId);
        request.putQueryParameter("SendDate", sendDate);
        request.putQueryParameter("PageSize", null==pageSize?"10":pageSize);
        request.putQueryParameter("CurrentPage", null ==curPage?"1":curPage);
        Map<String,SmsSendDetailDTO> smsSendDetailMap = new HashMap<>();
        try {
            if (Common.isNotEmpty(phones)){
                CommonResponse response;
                QuerySendResult sendResult;
                for (String phone:phones){
                    request.putQueryParameter("PhoneNumber", phone);
                    response = client.getCommonResponse(request);
                    sendResult =JSON.parseObject(response.getData(),QuerySendResult.class);
                    if (null != sendResult &&
                            null != sendResult.getSmsSendDetailDTOs() &&
                            Common.isNotNull(sendResult.getSmsSendDetailDTOs().getSmsSendDetailDTO())){
                        smsSendDetailMap.put(phone,sendResult.getSmsSendDetailDTOs().getSmsSendDetailDTO().get(0));
                    }
                }
            }
        } catch (Exception e) {
            log.error(ERROR_INFO,e);
            exceptionResult.put(MESSAGE, ERROR_INFO);
            exceptionResult.put(CODE, e.getMessage());
        }
        return smsSendDetailMap;
    }
}
