package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.insurances.util.LocalDateConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * @author fxj
 * @description 已投保查询返回类
 * @date 2022-07-21 09:46:09
 */
@Data
@Tag(name = "已投保查询返回类")
public class PolicyListVo implements Serializable {
	private static final long serialVersionUID = -6673220061558171816L;

	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;
	/**
	 * 保单号
	 */
	@Length(max = 50, message = "保单号 不能超过50 个字符" )
	@ExcelAttribute(name = "保单号", maxLength = 50, isNotEmpty = true,errorInfo = "保单号不能为空")
	@ExcelProperty("保单号" )
	@Schema(description = "保单号")
	private String policyNo;

	/**
	 * 保单开始日期
	 */
	@ExcelAttribute(name = "保单开始日期",isDate = true,  isNotEmpty = true,dateFormat = DateUtil.ISO_EXPANDED_DATE_FORMAT, errorInfo = "保单开始日期不能为空")
	@ExcelProperty("保单开始日期" )
	@Schema(description = "保单开始日期")
	private String policyStart;

	/**
	 * 保单截止日期
	 */
	@ExcelAttribute(name = "保单截止日期", isDate = true, isNotEmpty = true,dateFormat = DateUtil.ISO_EXPANDED_DATE_FORMAT,errorInfo = "保单截止日期不能为空")
	@ExcelProperty("保单截止日期" )
	@Schema(description = "保单截止日期")
	private String policyEnd;

	/**
	 * 保险公司
	 */
	@ExcelAttribute(name = "保险公司", maxLength = 60, isNotEmpty = true,errorInfo = "保险公司不能为空")
	@ExcelProperty("保险公司" )
	@Schema(description = "保险公司")
	private String insuranceCompanyName;

	/**
	 * 险种
	 */
	@ExcelAttribute(name = "险种", maxLength = 50, isNotEmpty = true,errorInfo = "险种不能为空")
	@ExcelProperty("险种" )
	@Schema(description = "险种")
	private String insuranceTypeName;

	/**
	 * 商险购买地省code
	 */
	@Schema(description = "商险购买地省code")
	@ExcelIgnore
	private Integer insuranceProvince;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
	@ExcelIgnore
	private String insuranceProvinceName;

	/**
	 * 商险购买地市code
	 */
	@Schema(description = "商险购买地市code")
	@ExcelIgnore
	private Integer insuranceCity;

	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "商险购买地")
	private String insuranceCityName;

	/**
	 * 购买标准
	 */
	@Schema(description = "购买标准")
	private String buyStandard;

	/**
	 * 险种主键
	 */
	@Schema(description = "险种主键")
	private Long insuranceTypeId;
}
