package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.csp.vo.EmployeeRegistrationCustomerUserUpdateVo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.EmployeeRegistrationPre;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeRegistrationPreVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TEmployeeInsurancePreService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 商险待办任务表
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/temployeeinsurancepre" )
@Tag(name = "商险待办任务表管理")
public class TEmployeeInsurancePreController {

    private final TEmployeeInsurancePreService tEmployeeInsurancePreService;

	private final MenuUtil menuUtil;

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tEmployeeInsurancePre 商险待办任务表
     * @return
     */
    @Operation(description = "简单分页查询")
    @PostMapping("/page")
    public R<IPage<TEmployeeInsurancePre>> getTEmployeeInsurancePrePage(Page<TEmployeeInsurancePre> page, @RequestBody TEmployeeInsurancePreSearchVo tEmployeeInsurancePre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tEmployeeInsurancePre);
		return new R<>(tEmployeeInsurancePreService.getTEmployeeInsurancePrePage(page,tEmployeeInsurancePre));
    }

	/**
	 * 商险待购买数量查询
	 * @param tEmployeeInsurancePre 商险待办任务表
	 * @return
	 */
	@Operation(description = "商险待购买数量查询")
	@GetMapping("/getListCount")
	public R getListCount(TEmployeeInsurancePreSearchVo tEmployeeInsurancePre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tEmployeeInsurancePre);
		return R.ok(tEmployeeInsurancePreService.getTEmployeeInsuranceCount(tEmployeeInsurancePre));
	}

	/**
	 * 不分页查询
	 * @param tEmployeeInsurancePre 商险待办任务表
	 * @return
	 */
	@Operation(description = "不分页查询")
	@GetMapping("/noPage")
	public R<List<TEmployeeInsurancePre>> getTEmployeeInsurancePrePage(TEmployeeInsurancePreSearchVo tEmployeeInsurancePre) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tEmployeeInsurancePre);
		return new R<>(tEmployeeInsurancePreService.getTEmployeeInsurancePreNoPage(tEmployeeInsurancePre));
	}

    /**
     * 通过id查询商险待办任务表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    public R<TEmployeeInsurancePre> getById(@PathVariable("id" ) String id) {
        return R.ok(tEmployeeInsurancePreService.getById(id));
    }

    /**
     * 新增商险待办任务表
     * @param tEmployeeInsurancePre 商险待办任务表
     * @return R
     */
    @Operation(summary = "新增商险待办任务表", description = "新增商险待办任务表")
    @SysLog("新增商险待办任务表" )
    @PostMapping
    public R<Boolean> save(@RequestBody TEmployeeInsurancePre tEmployeeInsurancePre) {
        return R.ok(tEmployeeInsurancePreService.save(tEmployeeInsurancePre));
    }

    /**
     * 修改商险待办任务表
     * @param tEmployeeInsurancePre 商险待办任务表
     * @return R
     */
    @Operation(summary = "修改商险待办任务表", description = "修改商险待办任务表")
    @SysLog("修改商险待办任务表" )
    @PutMapping
    public R<Boolean> updateById(@RequestBody TEmployeeInsurancePre tEmployeeInsurancePre) {
        return R.ok(tEmployeeInsurancePreService.updateById(tEmployeeInsurancePre));
    }

    /**
     * 通过id删除商险待办任务表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除商险待办任务表", description = "通过id删除商险待办任务表：hasPermission('insurances_temployeeinsurancepre_del')")
    @SysLog("通过id删除商险待办任务表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('insurances_temployeeinsurancepre_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tEmployeeInsurancePreService.removeById(id));
    }

    /**
     * 商险待办任务表 批量导出
     * @author huych
     * @date 2025-03-31 12:25:13
     **/
    @Operation(description = "导出商险待办任务表")
    @PostMapping("/export")
    public void export(HttpServletResponse response, @RequestBody TEmployeeInsurancePreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		tEmployeeInsurancePreService.listExport(response,searchVo);
    }

	/**
	 * 商险派单信息单个/批量确认
	 * @author huych
	 * @date 2025-03-31 12:25:13
	 **/
	@Operation(description = "商险派单信息单个/批量确认")
	@PostMapping("/confirm")
	public R confirm(@RequestBody List<String> idList) {
		return tEmployeeInsurancePreService.confirm(idList);
	}


	/**
	 * 商险派单信息批量派单
	 * @author huych
	 * @date 2025-03-31 12:25:13
	 **/
	@Operation(description = "商险派单信息单个/批量派单")
	@PostMapping("/batchDispatcherInsurance")
	public R batchDispatcherInsurance(@RequestBody List<String> idList,@RequestParam(required = false) String isExit) {
		return tEmployeeInsurancePreService.batchDispatcherInsurance(idList, isExit, false);
	}

	/**
	 * 商险派单信息查询
	 * @author huych
	 * @date 2025-04-08 14:31:35
	 **/
	@Operation(description = "商险派单入职确认信息查询")
	@Inner
	@PostMapping("/inner/selectInsurancePreInfoList")
	public TEmployeeInsuranceSelectVo selectInsurancePreInfoList(@RequestBody TEmployeeInsurancePreVo preVo) {
		return tEmployeeInsurancePreService.selectInsurancePreInfoList(preVo);
	}

	/**
	 * 新增商险待购买
	 * @author huych
	 * @date 2025-04-09 9:26:35
	 **/
	@Operation(description = "新增商险待购买")
	@Inner
	@PostMapping("/inner/saveInsurancePreInfo")
	public Boolean saveInsurancePreInfo(@RequestBody EmployeeRegistrationPreVo preVo) {
		return tEmployeeInsurancePreService.saveInsurancePreInfo(preVo);
	}

	/**
	 * 信息修改入口新增商险已购买明细
	 * @author huych
	 * @date 2025-08-14 11:46:16
	 **/
	@Operation(description = "信息修改入口新增商险已购买明细")
	@Inner
	@PostMapping("/inner/updateInfoSaveInsurancePreInfo")
	public Boolean updateInfoSaveInsurancePreInfo(@RequestBody EmployeeRegistrationPre pre) {
		return tEmployeeInsurancePreService.updateInfoSaveInsurancePreInfo(pre);
	}

	/**
	 * 信息修改入口删除商险已购买明细
	 * @author huych
	 * @date 2025-08-14 11:46:16
	 **/
	@Operation(description = "信息修改入口删除商险已购买明细")
	@Inner
	@PostMapping("/inner/deleteInsurancePreInfo")
	public Boolean deleteInsurancePreInfo(@RequestBody EmployeeRegistrationPre pre) {
		return tEmployeeInsurancePreService.deleteInsurancePreInfo(pre);
	}

	/**
	 * 商险状态是否正常判断
	 * @author huych
	 * @date 2025-08-05 16:26:38
	 **/
	@Operation(description = "商险状态是否正常判断")
	@Inner
	@PostMapping("/inner/checkExitInsuanceIsProcess")
	public Boolean checkExitInsuanceIsProcess(@RequestBody EmployeeRegistrationPreVo preVo) {
		return tEmployeeInsurancePreService.checkExitInsuanceIsProcess(preVo);
	}

	/**
	 * 更新商险待购买的前端客服姓名
	 * @author huych
	 * @date 2025-04-09 9:26:35
	 **/
	@Operation(description = "更新商险待购买的前端客服姓名")
	@Inner
	@PostMapping("/inner/updateInsurancePreCustomerName")
	public void updateInsurancePreCustomerName(@RequestBody EmployeeRegistrationCustomerUserUpdateVo updateVo) {
		tEmployeeInsurancePreService.updateInsurancePreCustomerName(updateVo);
	}

	/**
	 * 派单当日9点统一推送确认信息
	 * @author huych
	 * @date 2025-04-09 9:33:16
	 * @return void
	 */
	@SysLog("派单当日9点统一推送确认信息")
	@Inner
	@PostMapping("/inner/pushWxConfrimMessage")
	public void pushWxConfrimMessage() {
		tEmployeeInsurancePreService.pushWxConfrimMessage();
	}

	/**
	 * 每天下午三点二十推送待派单数据
	 * @author huych
	 * @date 2025-04-11 10:46:12
	 * @return void
	 */
	@SysLog("每天下午三点二十推送待派单数据")
	@Inner
	@PostMapping("/inner/pushDisConfrimInsurances")
	public void pushDisConfrimInsurances() {
		tEmployeeInsurancePreService.pushDisConfrimInsurances();
	}

	/**
	 * @param empPreId 入职确认信息表ID
	 * @Description: 获取商险信息
	 * @Author: hgw
	 * @Date: 2025/4/8 9:23
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre>>
	 **/
	@Inner
	@PostMapping("/inner/getListByEmpPreId")
	public EmployeePreLogListVo getListByEmpPreId(@RequestBody String empPreId){
		return tEmployeeInsurancePreService.getListByEmpPreId(empPreId);
	}

	/**
	 * @Description: 先删后增
	 * @Author: hgw
	 * @Date: 2025/4/10 14:49
	 * @return: java.lang.Boolean
	 **/
	@Inner
	@PostMapping("/inner/saveOrUpdateInsuranceList")
	public Boolean saveOrUpdateInsuranceList(@RequestBody List<TEmployeeInsurancePre> preList) {
		return tEmployeeInsurancePreService.saveOrUpdateInsuranceList(preList);
	}

	/**
	 * @Description: 清空
	 * @Author: hgw
	 * @Date: 2025/4/10 14:45
	 * @return: java.lang.Boolean
	 **/
	@Inner
	@PostMapping("/inner/deleteInsuranceByPreId")
	public Boolean deleteInsuranceByPreId(@RequestBody String preId) {
		return tEmployeeInsurancePreService.deleteInsuranceByPreId(preId);
	}

	/**
	 * @param empPreId 入职确认信息表ID
	 * @Description: 获取商险已购买信息
	 * @Author: huych
	 * @Date: 2025/8/7 10:25
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsurancePreDetail>>
	 **/
	@Inner
	@PostMapping("/inner/getExitInsuranceListByEmpPreId")
	public EmployeePreInsuranceListVo getExitInsuranceListByEmpPreId(@RequestBody String empPreId){
		return tEmployeeInsurancePreService.getExitInsuranceListByEmpPreId(empPreId);
	}

}
