/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 预入职-员工声明
 *
 * @author hgw
 * @date 2024-06-17 11:24:00
 */
@Data
@TableName("t_pre_emp_declaration")
@Schema(description = "预入职-员工声明")
public class TPreEmpDeclaration implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 员工声明
	 */
	@ExcelAttribute(name = "员工声明", maxLength = 500)
	@Length(max = 200, message = "员工声明不能超过500个字符")
	@ExcelProperty("员工声明")
	@Schema(description = "员工声明")
	private String contentOne;
	/**
	 * 员工确认
	 */
	@ExcelAttribute(name = "员工确认", maxLength = 500)
	@Length(max = 200, message = "员工确认不能超过500个字符")
	@ExcelProperty("员工确认")
	@Schema(description = "员工确认")
	private String contentTwo;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private LocalDateTime createTime;

}
