/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

/**
 * 预入职-员工学历信息表
 *
 * @author hgw
 * @date 2024-06-17 11:24:01
 */
@Data
@TableName("t_pre_emp_education")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-员工学历信息表")
public class TPreEmpEducation extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;

	/**
	 * 原ID——用来判断是否从档案查询带出的
	 */
	@Schema(description = "原ID——用来判断是否从档案查询带出的")
	@ExcelIgnore
	private String oldId;
	/**
	 * 预入职主表ID
	 */
	@ExcelAttribute(name = "预入职主表ID", isNotEmpty = true, errorInfo = "预入职主表ID不能为空", maxLength = 32)
	@NotBlank(message = "预入职主表ID不能为空")
	@Length(max = 32, message = "预入职主表ID不能超过32个字符")
	@ExcelProperty("预入职主表ID")
	@Schema(description = "预入职主表ID")
	private String preMainId;
	/**
	 * 员工ID
	 */
	@ExcelAttribute(name = "员工ID", isNotEmpty = true, errorInfo = "员工ID不能为空", maxLength = 32)
	@NotBlank(message = "员工ID不能为空")
	@Length(max = 32, message = "员工ID不能超过32个字符")
	@ExcelProperty("员工ID")
	@Schema(description = "员工ID")
	private String empId;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, errorInfo = "员工姓名不能为空", maxLength = 32)
	@NotBlank(message = "员工姓名不能为空")
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 员工编码
	 */
	@ExcelAttribute(name = "员工编码", isNotEmpty = true, errorInfo = "员工编码不能为空", maxLength = 32)
	@NotBlank(message = "员工编码不能为空")
	@Length(max = 32, message = "员工编码不能超过32个字符")
	@ExcelProperty("员工编码")
	@Schema(description = "员工编码")
	private String empCode;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 32)
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 入学日期
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@ExcelAttribute(name = "入学日期", isDate = true)
	@ExcelProperty("入学日期")
	@Schema(description = "入学日期")
	private Date entryDate;
	/**
	 * 学历名称
	 */
	@ExcelAttribute(name = "学历名称", maxLength = 32)
	@Length(max = 32, message = "学历名称不能超过32个字符")
	@ExcelProperty("学历名称")
	@Schema(description = "学历名称")
	private String educationName;
	/**
	 * 结业日期
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@ExcelAttribute(name = "结业日期", isDate = true)
	@ExcelProperty("结业日期")
	@Schema(description = "结业日期")
	private Date gradutionDate;
	/**
	 * 学校名称
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@ExcelAttribute(name = "学校名称", maxLength = 64)
	@Length(max = 64, message = "学校名称不能超过64个字符")
	@ExcelProperty("学校名称")
	@Schema(description = "学校名称")
	private String school;
	/**
	 * 学制
	 */
	@ExcelAttribute(name = "学制", maxLength = 32)
	@Length(max = 32, message = "学制不能超过32个字符")
	@ExcelProperty("学制")
	@Schema(description = "学制")
	private String educationSystem;
	/**
	 * 最高学历标识0是/1否
	 */
	@ExcelAttribute(name = "最高学历标识0是/1否", maxLength = 1)
	@Length(max = 1, message = "最高学历标识0是/1否不能超过1个字符")
	@ExcelProperty("最高学历标识0是/1否")
	@Schema(description = "最高学历标识0是/1否")
	private String highIdentification;
	/**
	 * 学历类型：全日制、自考、函授等
	 */
	@ExcelAttribute(name = "学历类型：全日制、自考、函授等", maxLength = 32)
	@Length(max = 32, message = "学历类型：全日制、自考、函授等不能超过32个字符")
	@ExcelProperty("学历类型：全日制、自考、函授等")
	@Schema(description = "学历类型：全日制、自考、函授等")
	private String type;
	/**
	 * 院系
	 */
	@ExcelAttribute(name = "院系", maxLength = 64)
	@Length(max = 64, message = "院系不能超过64个字符")
	@ExcelProperty("院系")
	@Schema(description = "院系")
	private String collageSystem;
	/**
	 * 是否删除 0未删除/1删除
	 */
	@ExcelAttribute(name = "是否删除 0未删除/1删除", maxLength = 1)
	@Length(max = 1, message = "是否删除 0未删除/1删除不能超过1个字符")
	@ExcelProperty("是否删除 0未删除/1删除")
	@Schema(description = "是否删除 0未删除/1删除")
	private String deleteFlag;
	/**
	 * 结算主体ID
	 */
	@ExcelAttribute(name = "结算主体ID", maxLength = 32)
	@Length(max = 32, message = "结算主体ID不能超过32个字符")
	@ExcelProperty("结算主体ID")
	@Schema(description = "结算主体ID")
	private String settleDomain;
	/**
	 * 派单标识  1 代表派单生成， 派单审核通过后清空标识 专门用于派单作废
	 */
	@ExcelAttribute(name = "派单标识  1 代表派单生成， 派单审核通过后清空标识 专门用于派单作废", maxLength = 1)
	@Length(max = 1, message = "派单标识  1 代表派单生成， 派单审核通过后清空标识 专门用于派单作废不能超过1个字符")
	@ExcelProperty("派单标识  1 代表派单生成， 派单审核通过后清空标识 专门用于派单作废")
	@Schema(description = "派单标识  1 代表派单生成， 派单审核通过后清空标识 专门用于派单作废")
	private String dispatchFlag;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 64)
	@Length(max = 64, message = "备注不能超过64个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String remark;
	/**
	 * 证书名称
	 */
	@ExcelAttribute(name = "证书名称", maxLength = 32)
	@Length(max = 32, message = "证书名称不能超过32个字符")
	@ExcelProperty("证书名称")
	@Schema(description = "证书名称")
	private String certificationName;
	/**
	 * 专业
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	@ExcelAttribute(name = "专业", maxLength = 64)
	@Length(max = 64, message = "专业不能超过64个字符")
	@ExcelProperty("专业")
	@Schema(description = "专业")
	private String major;

	/**
	 * @Description: 最高教育经历
	 * @Author: hgw
	 * @Date: 2024/6/20 15:11
	 * @return:
	 **/
	@TableField(exist = false)
	private List<TAttaInfo> attaList;

}
