/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

/**
 * 预入职-主表
 *
 * @author hgw
 * @date 2024-06-17 11:31:08
 */
@Data
@TableName("t_pre_emp_main")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "预入职-主表")
public class TPreEmpMain extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 审核状态（0草稿；1待完善；2待审核；3审核不通过；4审核通过；5初始未保存）
	 */
	@ExcelAttribute(name = "审核状态（0草稿；1待完善；2待审核；3审核不通过；4审核通过；5初始未保存）", isNotEmpty = true, errorInfo = "审核状态（0草稿；1待完善；2待审核；3审核不通过；4审核通过；5初始未保存）", maxLength = 1)
	@NotBlank(message = "审核状态（0草稿；1待完善；2待审核；3审核不通过；4审核通过；5初始未保存）不能为空")
	@Length(max = 1, message = "审核状态（0草稿；1待完善；2待审核；3审核不通过；4审核通过；5初始未保存）不能超过1个字符")
	@ExcelProperty("审核状态（0草稿；1待完善；2待审核；3审核不通过；4审核通过；5初始未保存）")
	@Schema(description = "审核状态（0草稿；1待完善；2待审核；3审核不通过；4审核通过；5初始未保存）")
	private String status;
	/**
	 * 员工ID
	 */
	@ExcelAttribute(name = "员工ID", maxLength = 32)
	@Length(max = 32, message = "员工ID不能超过32个字符")
	@ExcelProperty("员工ID")
	@Schema(description = "员工ID")
	private String empId;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 32)
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelProperty("员工姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 手机号码
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 32)
	@Length(max = 32, message = "手机号码不能超过32个字符")
	@ExcelProperty("手机号码")
	@Schema(description = "手机号码")
	private String empPhone;
	/**
	 * 微信名
	 */
	@ExcelAttribute(name = "微信名", maxLength = 32)
	@Length(max = 32, message = "微信名不能超过32个字符")
	@ExcelProperty("微信名")
	@Schema(description = "微信名")
	private String empWx;
	/**
	 * 客户id
	 */
	@ExcelAttribute(name = "客户id", maxLength = 32)
	@Length(max = 32, message = "客户id不能超过32个字符")
	@ExcelProperty("客户id")
	@Schema(description = "客户id")
	private String unitId;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@ExcelProperty("客户名称")
	@Schema(description = "客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Length(max = 32, message = "客户编码不能超过32个字符")
	@ExcelProperty("客户编码")
	@Schema(description = "客户编码")
	private String unitNo;
	/**
	 * 项目id
	 */
	@ExcelAttribute(name = "项目id", maxLength = 32)
	@Length(max = 32, message = "项目id不能超过32个字符")
	@ExcelProperty("项目id")
	@Schema(description = "项目id")
	private String deptId;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@ExcelProperty("项目名称")
	@Schema(description = "项目名称")
	private String deptName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目编码不能为空", maxLength = 30)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 30, message = "项目编码不能超过30个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 业务类型一级分类
	 */
	@ExcelAttribute(name = "业务类型一级分类", maxLength = 32)
	@Length(max = 32, message = "业务类型一级分类不能超过32个字符")
	@ExcelProperty("业务类型一级分类")
	@Schema(description = "业务类型一级分类")
	private String businessPrimaryType;
	/**
	 * 业务类型二级分类
	 */
	@ExcelAttribute(name = "业务类型二级分类", maxLength = 32)
	@Length(max = 32, message = "业务类型二级分类不能超过32个字符")
	@ExcelProperty("业务类型二级分类")
	@Schema(description = "业务类型二级分类")
	private String businessSecondType;
	/**
	 * 业务类型三级分类
	 */
	@ExcelAttribute(name = "业务类型三级分类", maxLength = 32)
	@Length(max = 32, message = "业务类型三级分类不能超过32个字符")
	@ExcelProperty("业务类型三级分类")
	@Schema(description = "业务类型三级分类")
	private String businessThirdType;
	/**
	 * 业务类型汇总
	 */
	@ExcelAttribute(name = "业务类型汇总")
	@ExcelProperty("业务类型汇总")
	@Schema(description = "业务类型汇总")
	@TableField(exist = false)
	private String businessType;
	/**
	 * 员工类型（字典值，0外包1派遣2代理）
	 */
	@ExcelAttribute(name = "员工类型（字典值，0外包1派遣2代理）", isNotEmpty = true, errorInfo = "员工类型（字典值，0外包1派遣2代理）不能为空", maxLength = 2)
	@NotBlank(message = "员工类型（字典值，0外包1派遣2代理）不能为空")
	@Length(max = 2, message = "员工类型（字典值，0外包1派遣2代理）不能超过2个字符")
	@ExcelProperty("员工类型（字典值，0外包1派遣2代理）")
	@Schema(description = "员工类型（字典值，0外包1派遣2代理）")
	private String empNatrue;
	/**
	 * 审核人ID
	 */
	@ExcelAttribute(name = "审核人ID", maxLength = 32)
	@Length(max = 32, message = "审核人ID不能超过32个字符")
	@ExcelProperty("审核人ID")
	@Schema(description = "审核人ID")
	private String auditId;
	/**
	 * 审核人姓名
	 */
	@ExcelAttribute(name = "审核人姓名", maxLength = 20)
	@Length(max = 20, message = "审核人姓名不能超过20个字符")
	@ExcelProperty("审核人姓名")
	@Schema(description = "审核人姓名")
	private String auditName;
	/**
	 * 审核时间
	 */
	@ExcelAttribute(name = "审核时间", isDate = true)
	@ExcelProperty("审核时间")
	@Schema(description = "审核时间")
	private Date auditTime;
	/**
	 * 审核理由
	 */
	@ExcelAttribute(name = "审核理由", maxLength = 200)
	@Length(max = 200, message = "审核理由不能超过200个字符")
	@ExcelProperty("审核理由")
	@Schema(description = "审核理由")
	private String auditRemark;
	/**
	 * 结算主体ID
	 */
	@ExcelAttribute(name = "结算主体ID", maxLength = 32)
	@Length(max = 32, message = "结算主体ID不能超过32个字符")
	@ExcelProperty("结算主体ID")
	@Schema(description = "结算主体ID")
	private String settleDomain;
	/**
	 * 员工声明表ID，新申明要加一条新数据，关联这个主表
	 */
	@ExcelAttribute(name = "员工声明表ID", maxLength = 32)
	@Length(max = 32, message = "员工声明表ID不能超过32个字符")
	@ExcelProperty("员工声明表ID")
	@Schema(description = "员工声明表ID，新申明要加一条新数据，关联这个主表")
	private String declarationId;

	// 数据来源 默认0: '扫码进入', 1: 'PC批量导入'
	@ExcelAttribute(name = "数据来源", maxLength = 32)
	@ExcelProperty("数据来源")
	@Schema(description = "数据来源")
	private String sourType;

	@Schema(description = "状态多个")
	@TableField(exist = false)
	private String[] statusArray;

	@Schema(description = "员工类型多个")
	@TableField(exist = false)
	private String[] empNatureArray;

	@Schema(description = "提交时间起")
	@TableField(exist = false)
	private String createTimeStart;

	@Schema(description = "提交时间止")
	@TableField(exist = false)
	private String createTimeEnd;

	@Schema(description = "查询limit  开始")
	@TableField(exist = false)
	private int limitStart;

	@Schema(description = "查询limit  数据条数")
	@TableField(exist = false)
	private int limitEnd;

	@Schema(description = "选中ID,多个逗号分割")
	@TableField(exist = false)
	private String ids;

	// 导入预入职使用
	@TableField(exist = false)
	private String firstWorkFlag;
	@TableField(exist = false)
	private String haveQualification;

	/**
	 * 其他附件
	 */
	@TableField(exist = false)
	private List<TPreEmpOtherFile> otherFiles;

	// 档案编辑的其他附件之外的附件，例如：身份证正反面，户口本2页、学历学信、员工声明、员工确认
	@TableField(exist = false)
	private List<TAttaInfo> attaList;

}
