package com.yifu.cloud.plus.v1.yifu.archives.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitor;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmpMainDetailVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TCompleteMonitorInfoVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TCompleteMonitorSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;

/**
 * 档案完整度监控
 *
 * @author huyc
 * @date 2024-06-17 16:08:58
 */
public interface TCompleteMonitorService extends IService<TCompleteMonitor> {
    /**
     * 档案完整度监控简单分页查询
     * @param tCompleteMonitor 档案完整度监控
     * @return
     */
    IPage<TCompleteMonitor> getTCompleteMonitorPage(Page<TCompleteMonitor> page, TCompleteMonitorSearchVo tCompleteMonitor);

	/**
	 * @Description: 详情
	 * @Author: huyc
	 * @Date: 2024/6/28 11:41
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TPreEmpMain>
	 **/
	R<EmpMainDetailVo> getInfoById(String id,String deptId);

	/**
	 * 档案完整度监控导出
	 * @param searchVo 档案完整度监控
	 * @return
	 */
    void listExport(HttpServletResponse response, TCompleteMonitorSearchVo searchVo);

	/**
	 * 档案完整度监控生成
	 * @return
	 */
	void createComlpeteMonitor() throws IllegalAccessException;

	/**
	 * 根据项目编码刷新项目完整度状态
	 * @return
	 */
	void updateProjectStatusByDeptNo(String deptNo)  throws IllegalAccessException;

	/**
	 * 档案完整度监控简单分页查询
	 * @param completeMonitorInfoVo
	 * @return
	 */
	IPage<TCompleteMonitorInfoVo> getMonitorEmpInfoListPage(Page<TCompleteMonitorInfoVo> page, TCompleteMonitorInfoVo completeMonitorInfoVo);

	// 导出全量
	void exportAll(HttpServletResponse response, TCompleteMonitorSearchVo searchVo);

	/**
	 * @Description: 返回异常提示的文件
	 * @Author: hgw
	 * @Date: 2024/10/29 10:24
	 * @return: void
	 **/
	void exportError(HttpServletResponse response, String errorMessage);

}
