package com.yifu.cloud.plus.v1.business.service.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.entity.settle.TBusSettle;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * B端结算表
 *
 * @author hgw
 * @date 2021-08-16 15:58:09
 */
public interface TBusSettleService extends IService<TBusSettle> {

     /**
      * B端结算表简单分页查询
      *
      * @param tBusSettle B端结算表
      * @return
      */
     IPage<TBusSettle> getTBusSettlePage(Page<TBusSettle> page, TBusSettle tBusSettle);

     /**
      * @param tBusSettle
      * @Description: 列表
      * @Author: hgw
      * @Date: 2021/8/16 16:37
      * @return: java.util.List<com.yifu.cloud.v1.hrobusiness.api.entity.settle.TBusSettle>
      **/
     List<TBusSettle> getTBusSettleList(TBusSettle tBusSettle);

    /**
     * @description: 解析zip文件包中的多个附件，并生成结算记录
     * @param file zip文件包
     * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
     * @author: wangweiguo
     * @date: 2021/8/19
     */
    R<Boolean> importZip(MultipartFile file);
}
