/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.common.core.constant;

/**
 * @author lengleng
 * @date 2020年01月01日
 * <p>
 * 缓存的key 常量
 */
public interface CacheConstants {

	/**
	 * oauth 缓存前缀
	 */
	String PROJECT_OAUTH_ACCESS = "yifu_oauth:access:";

	/**
	 * oauth 缓存令牌前缀
	 */
	String PROJECT_OAUTH_TOKEN = "yifu_oauth:token:";

	/**
	 * 验证码前缀
	 */
	String DEFAULT_CODE_KEY = "DEFAULT_CODE_KEY:";

	/**
	 * 菜单信息缓存
	 */
	String MENU_DETAILS = "menu_details";

	/**
	 * 用户信息缓存
	 */
	String USER_DETAILS = "user_details";

	/**
	 * 字典信息缓存
	 */
	String DICT_DETAILS = "dict_details";
	/**
	 * 字典转义信息缓存
	 */
	String REDIS_DICT_LABLE = "redis_dict_lable";

	/**
	 * 字典项信息缓存
	 */
	String DICT_ITEM_DETAILS = "dict_item_details";

	/**
	 * oauth 客户端信息
	 */
	String CLIENT_DETAILS_KEY = "yifu_oauth:client:details";

	/**
	 * 参数缓存
	 */
	String PARAMS_DETAILS = "params_details";

	/**
	 * 数据权限信息缓存
	 * data_auth_details0：用户组
	 * data_auth_details1：用户
	 * hgw
	 * 2022-6-9 17:29:49
	 */
	String DATA_AUTH_DETAILS = "data_auth_details";

	/**
	 * @Description: 每日员工主码缓存
	 * @Author: hgw
	 * @Date: 2022/6/21 17:09
	 **/
	String EVERYDAY_EMP_CODE = "everyday_emp_code";
	/**
	 * @Description: 每日员工合同的 申请编码 缓存
	 * @Author: hgw
	 * @Date: 2022/6/21 17:09
	 **/
	String EVERYDAY_EMP_CONTRACT_CODE = "everyday_emp_contract_code";

	/**
	 * @Description: 每日薪资表的 申请编码 缓存
	 * @Author: hgw
	 * @Date: 2022-11-2 09:56:32
	 **/
	String EVERYDAY_SALARY_FORM_CODE = "everyday_salary_form_code";

	String EVERYDAY_UNBUY_FORM_CODE = "everyday_unbuy_form_code";

	String EVERYDAY_UNBUYINFO_FORM_CODE = "everyday_unbuyinfo_form_code";

	/**
	 * @Description:  派单申请编码
	 * @Author: fxj
	 **/
	String EVERYDAY_DISPATCH_CODE = "everyday_dispatch_code";

	/**
	 * 区域数据--标签
	 */
	String AREA_LABEL = "area_label:";

	/**
	 * 区域数据--值
	 */
	String AREA_VALUE = "area_value:";

	/**
	 * 区域数据--标签
	 */
	String AREA_LABEL_GROUP = "area_label";

	/**
	 * 区域数据--值
	 */
	String AREA_VALUE_GROUP = "area_value";
	/**
	 * 区域数据--总-hgw-导出使用
	 */
	String AREA_VALUE_ALL = "area_all";
	/**
	 * 用户登录的项目vo缓存
	 */
	public static final String WXHR_SETTLE_DOMAIN_VOS_BY_USERID = ServiceNameConstants.ARCHIVES_SERVICE + "_SettleDomainVosByUserId";
	/**
	 * 缓存用户所拥有的项目编码
	 */
	public static final String WXHR_SETTLE_DOMAIN_NOS_BY_USERID = ServiceNameConstants.ARCHIVES_SERVICE + "_SettleDomainNosByUserId";

    String PUSH_PAYMENT_SOCIAL_FUND_CACHE = "push_payment_social_fund_cache";

	String PAYMENT_SOCIAL_THREE_IMPORT = "payment_social_three_import";

	String PAYMENT_SOCIAL_IMPORT = "payment_social_import";

	String PAYMENT_FUND_IMPORT = "payment_fund_import";

	String PAYMENT_SOCIAL_PUSH = "payment_social_push";

	String PAYMENT_SOCIAL_EXPORT = "payment_social_export";

	String PAYMENT_DISPATCH_BATCH_ADD_IMPORT = "payment_dispatch_batch_add_import";

	String MOBILE_CHANGE_LIMIT = "mobile_change_limit";

	String QUESTION_FEEDBACK_LIMIT = "question_feedback_limit";

	String PAYMENT_SEARCH_REPEAT = "payment_search_repeat";

	String PAYMENT_EXPORT_REPEAT = "payment_export_repeat";

	String PAYMENT_DISPATCH_BATCH_REDUCE_IMPORT = "payment_dispatch_batch_reduce_import";

	String PAYMENT_PRE_DISPATCH_BATCH_ADD_IMPORT = "payment_pre_dispatch_batch_add_import";

	String INSURANCE_BATCH_UPDATE_IMPORT = "insurance_batch_update_import";

	String DISPATCH_BATCH_AUDIT = "dispatch_batch_audit";

	String DISPATCH_BATCH_HANDLED = "dispatch_batch_handled";

	//社保公积金派单
	String PAYMENT_DISPATCH_BATCH_IMPORT = "payment_dispatch_batch_import";


	String EMP_ADD_LOCK ="emp_add_lock";

	String UNBUY_ADD_LOCK ="unbuy_add_lock";

	String SALARY_ACCOUNT_EXPORT_LOCK ="salary_account_export_lock";

	String SALARY_ACCOUNT_AUDIT_EXPORT_LOCK ="salary_account_audit_export_lock";

	String FUND_IMPORT_HANDLE_LOCK = "fund_import_handle_handle_lock";

	// 项目报销token的key
	String WX_REIMBURSEMENT_TOKEN = "WX_REIMBURSEMENT_TOKEN";
	// HCM出差的sign
	String HCM_CHU_CHAI_SIGN = "HCM_CHU_CHAI_SIGN";

	public static final String WX_ACCOSS_TOKEN = "WX_ACCOSS_TOKEN";

	/**
	 * 登录用户最近一次选择的收入证明单位名称
	 */
	public static final String WXHR_LAST_SELECT_COMPANY_NAME = "wxhr_last_select_company_name";

	/**
	 * C端发验证码前缀
	 */
	public static final String MVP_TOC_PHONE_CODE_PREFIX = "MVP_TOC_PHONE_CODE_";

	public static final String WX_JSAPI_TICKET = "WX_JSAPI_TICKET";

	// 商险不购买审批流分布式锁key InsuranceUnpurchase
	public static final String INSURANCEUNPURCHASE_PROCESS_CACHE = ServiceNameConstants.SERVICE_NAME_MVP + "_" + "ProcessCache:InsuranceUnpurchase";
}
