/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 发放结果明细(银企付款任务)
 *
 * @author hgw
 * @date 2024-11-15 17:12:14
 */
@Data
@TableName("ekp_bank_grant_detail")
@Schema(description = "发放结果明细(银企付款任务)")
public class EkpBankGrantDetail {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	/**
	 * 关联银企付款表主键
	 */
	@ExcelAttribute(name = "关联银企付款表主键", isNotEmpty = true, errorInfo = "关联银企付款表主键不能为空", maxLength = 36)
	@NotBlank(message = "关联银企付款表主键不能为空")
	@Length(max = 36, message = "关联银企付款表主键不能超过36个字符")
	@ExcelProperty("关联银企付款表主键")
	@Schema(description = "关联银企付款表主键")
	private String fdParentId;
	/**
	 * 流水号
	 */
	@ExcelAttribute(name = "流水号", maxLength = 50)
	@Length(max = 50, message = "流水号不能超过50个字符")
	@ExcelProperty("流水号")
	@Schema(description = "流水号")
	private String fdSerialNumber;
	/**
	 * 收款人名称
	 */
	@ExcelAttribute(name = "收款人名称", maxLength = 30)
	@Length(max = 30, message = "收款人名称不能超过30个字符")
	@ExcelProperty("收款人名称")
	@Schema(description = "收款人名称")
	private String fdPayeeName;
	/**
	 * 收款账号
	 */
	@ExcelAttribute(name = "收款账号", maxLength = 50)
	@Length(max = 50, message = "收款账号不能超过50个字符")
	@ExcelProperty("收款账号")
	@Schema(description = "收款账号")
	private String fdPayeeAccount;
	/**
	 * 金额
	 */
	@ExcelAttribute(name = "金额")
	@ExcelProperty("金额")
	@Schema(description = "金额")
	private Double fdMoney;
	/**
	 * 收款银行
	 */
	@ExcelAttribute(name = "收款银行", maxLength = 100)
	@Length(max = 100, message = "收款银行不能超过100个字符")
	@ExcelProperty("收款银行")
	@Schema(description = "收款银行")
	private String fdRecipientBank;
	/**
	 * 汇款用途：工资等
	 */
	@ExcelAttribute(name = "汇款用途：工资等", maxLength = 10)
	@Length(max = 10, message = "汇款用途：工资等不能超过10个字符")
	@ExcelProperty("汇款用途：工资等")
	@Schema(description = "汇款用途：工资等")
	private String fdRemittancePurpose;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 500)
	@Length(max = 500, message = "备注不能超过500个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String fdRemark;
	/**
	 * 发生时间
	 */
	@ExcelAttribute(name = "发生时间", isDate = true)
	@ExcelProperty("发生时间")
	@Schema(description = "发生时间")
	private LocalDateTime fdCreateTime;
	/**
	 * 失败反馈
	 */
	@ExcelAttribute(name = "失败反馈", maxLength = 500)
	@Length(max = 500, message = "失败反馈不能超过500个字符")
	@ExcelProperty("失败反馈")
	@Schema(description = "失败反馈")
	private String fdFailureFeedback;
	/**
	 * 发放状态：发放成功、发放失败
	 */
	@ExcelAttribute(name = "发放状态：发放成功、发放失败", maxLength = 30)
	@Length(max = 30, message = "发放状态：发放成功、发放失败不能超过30个字符")
	@ExcelProperty("发放状态：发放成功、发放失败")
	@Schema(description = "发放状态：发放成功、发放失败")
	private String fdGrantStatus;
	/**
	 * 处理状态:待发放、发放中、转手工
	 */
	@ExcelAttribute(name = "处理状态:待发放、发放中、转手工", maxLength = 30)
	@Length(max = 30, message = "处理状态:待发放、发放中、转手工不能超过30个字符")
	@ExcelProperty("处理状态:待发放、发放中、转手工")
	@Schema(description = "处理状态:待发放、发放中、转手工")
	private String fdHandleStatus;
	/**
	 * 失败处理编号
	 */
	@ExcelAttribute(name = "失败处理编号", maxLength = 20)
	@Length(max = 20, message = "失败处理编号不能超过20个字符")
	@ExcelProperty("失败处理编号")
	@Schema(description = "失败处理编号")
	private String fdHandleFailNo;
	/**
	 * 失败处理ID
	 */
	@ExcelAttribute(name = "失败处理ID", maxLength = 36)
	@Length(max = 36, message = "失败处理ID不能超过36个字符")
	@ExcelProperty("失败处理ID")
	@Schema(description = "失败处理ID")
	private String fdHandleFailId;
	/**
	 * 附件ID
	 */
	@ExcelAttribute(name = "附件ID", maxLength = 36)
	@Length(max = 36, message = "附件ID不能超过36个字符")
	@ExcelProperty("附件ID")
	@Schema(description = "附件ID")
	private String fdAttaId;
	/**
	 * 附件名称
	 */
	@ExcelAttribute(name = "附件名称", maxLength = 200)
	@Length(max = 200, message = "附件名称不能超过200个字符")
	@ExcelProperty("附件名称")
	@Schema(description = "附件名称")
	private String fdAttaName;
	/**
	 * 附件资源路径
	 */
	@ExcelAttribute(name = "附件资源路径", maxLength = 200)
	@Length(max = 200, message = "附件资源路径不能超过200个字符")
	@ExcelProperty("附件资源路径")
	@Schema(description = "附件资源路径")
	private String fdAttaSrc;
	/**
	 * 附件下载次数
	 */
	@ExcelAttribute(name = "附件下载次数")
	@ExcelProperty("附件下载次数")
	@Schema(description = "附件下载次数")
	private Integer fdDownloadNum;
	/**
	 * 失败次数
	 */
	@ExcelAttribute(name = "失败次数")
	@ExcelProperty("失败次数")
	@Schema(description = "失败次数")
	private Integer fdFailNum;
	/**
	 * 发放次数
	 */
	@ExcelAttribute(name = "发放次数")
	@ExcelProperty("发放次数")
	@Schema(description = "发放次数")
	private Integer fdGrantNum;

	@ExcelAttribute(name = "收款账户短信通知手机号码")
	@ExcelProperty("收款账户短信通知手机号码")
	@Schema(description = "收款账户短信通知手机号码")
	private String fdEmpPhone;

	@ExcelAttribute(name = "批次号", maxLength = 36)
	@Length(max = 36, message = "批次号不能超过36个字符")
	@ExcelProperty("批次号")
	@Schema(description = "批次号")
	private String fdWxNo;

	@ExcelAttribute(name = "MD码", maxLength = 100)
	@Length(max = 100, message = "MD码不能超过100个字符")
	@ExcelProperty("MD码")
	@Schema(description = "MD码")
	private String fdMdCode;

	@ExcelAttribute(name = "工资明细ID", maxLength = 36)
	@Length(max = 36, message = "工资明细ID不能超过36个字符")
	@ExcelProperty("工资明细ID")
	@Schema(description = "工资明细ID，用来同步中信银行状态")
	private String fdSalaryId;

}
