package com.yifu.cloud.plus.v1.permission.service;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserInfo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserInfoSaveVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserInfoSearchVo;

import java.util.List;

/**
 * 新权限-账号管理表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
public interface SysUserInfoService extends IService<SysUserInfo> {
	/**
	 * 新权限-账号管理表简单分页查询
	 *
	 * @param sysUserInfo 新权限-账号管理表
	 * @return
	 */
	IPage<SysUserInfo> getSysUserInfoPage(Page<SysUserInfo> page, SysUserInfoSearchVo sysUserInfo);

	List<SysUserInfo> noPageDiy(SysUserInfoSearchVo searchVo);

	/**
	 * @param fdId
	 * @Description: 查看
	 * @Author: hgw
	 * @Date: 2023/8/30 15:10
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserInfoSaveVo>
	 **/
	R<SysUserInfoSaveVo> getInfoById(String fdId);

	/**
	 * @param vo
	 * @Description: 新增或编辑新权限-账号表
	 * @Author: hgw
	 * @Date: 2023/8/30 15:10
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.Boolean>
	 **/
	R<String> saveOrUpdateUserInfo(SysUserInfoSaveVo vo);

	/**
	 * @param
	 * @Description: 同步并更新账号信息
	 * @Author: hgw
	 * @Date: 2023/9/4 11:30
	 * @return: void
	 **/
	void doRefreshEkpUser();

	/**
	 * @Description: 给EKP用的，获取权限
	 * @Author: hgw
	 * @Date: 2023/9/8 16:35
	 * @return: java.lang.String
	 **/
	String testPermission(String modelId, String userId);

	IPage<SysUserInfo> getUserByCodeOrLoginName(Page<SysUserInfo> page, String code);

}
