/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccountItem;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author fxj
 * @Description 工资报账主表（工资条）导出
 * @Date 11:17 2024/10/22
 * @Param
 * @return
**/
@Data
@Schema(description = "工资报账主表（工资条）")
@HeadFontStyle(fontHeightInPoints = 11)
public class SalaryAccountExportVo{
	/**
	 * 项目name
	 */
	@ExcelAttribute(name = "项目名称", isNotEmpty = true, errorInfo = "项目name不能为空", maxLength = 50)
	@NotBlank(message = "项目名称不能为空")
	@Length(max = 50, message = "项目名称不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String deptName;
	/**
	 * 项目no
	 */
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, errorInfo = "项目no不能为空", maxLength = 50)
	@NotBlank(message = "项目编码不能为空")
	@Length(max = 50, message = "项目编码不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String deptNo;

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Length(max = 50, message = "员工姓名不能超过50个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 员工身份证号
	 */
	@ExcelAttribute(name = "身份证号", maxLength = 25)
	@Length(max = 25, message = "身份证号不能超过25个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 手机号
	 */
	@ExcelAttribute(name = "手机号码", maxLength = 11)
	@Length(max = 11, message = "手机号码不能超过11个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码")
	private String empPhone;
	/**
	 * 银行卡号
	 */
	@ExcelProperty("银行卡号")
	private String bankNo;
	/**
	 * 开户行总行
	 */
	@ExcelProperty("开户行总行")
	private String bankName;

	/**
	 * 开户行省
	 */
	@ExcelProperty("开户行省")
	private String bankProvince;
	/**
	 * 开户行市
	 */
	@ExcelProperty("开户行市")
	private String bankCity;
	/**
	 * 开户行支行
	 */
	@ExcelProperty("开户行支行")
	private String bankSubName;

	/**
	 * 表单类型0：薪资；1：绩效；2：其他；3：劳务费；4：稿酬
	 */
	@ExcelProperty("表单类型")
	private String formType;
	/**
	 * 薪酬月份
	 */
	@ExcelProperty("薪酬月份")
	private String salaryMonth;
	/**
	 * 结算月
	 */
	@ExcelProperty("结算月")
	private String settlementMonth;
}
