/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.controller;

import com.alibaba.fastjson.JSONObject;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialFriendPushService;
import com.yifu.cloud.plus.v1.yifu.social.service.TSocialFriendService;
import com.yifu.cloud.plus.v1.yifu.social.vo.FriendResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 税友
 *
 * @author hgw
 * @date 2024-12-6 15:46:04
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tsocialfriend")
@Tag(name = "税友")
public class TSocialFriendController {

	private final TSocialFriendService tSocialFriendService;
	private final TSocialFriendPushService tSocialFriendPushService;

	@Operation(description = "1定时任务推送税友")
	@PostMapping("/inner/doPushFriend")
	@SysLog("1定时任务推送税友")
	@Inner
	public R<String> doPushFriendTest() {
		return tSocialFriendPushService.pushFriend(null);
	}

	@Operation(description = "2定时任务获取税友")
	@PostMapping("/inner/doGetFriendByRequestId")
	@SysLog("2定时任务获取税友")
	@Inner
	public R<String> doGetFriendByRequestId() {
		return tSocialFriendService.getInfoByRequestId();
	}

}
